
#include <windows.h>
#ifndef  _KERNEL_H_567890
#define  _KERNEL_H_567890



typedef unsigned short USHORT;


typedef  unsigned long  ULONG;
typedef  unsigned char  UCHAR;
typedef  void*	        PVOID;

typedef LONG    NTSTATUS;
#define STATUS_SUCCESS				((NTSTATUS)0x00000000L)
#define NT_SUCCESS(status)          ((NTSTATUS)(status)>=0)
#define STATUS_INFO_LENGTH_MISMATCH ((NTSTATUS)0xC0000004L)


typedef enum _SYSTEM_HANDLE_TYPE
{
	OB_TYPE_UNKNOWN = 0,
	OB_TYPE_TYPE = 1,
	OB_TYPE_DIRECTORY,
	OB_TYPE_SYMBOLIC_LINK,
	OB_TYPE_TOKEN,
	OB_TYPE_PROCESS,
	OB_TYPE_THREAD,
	OB_TYPE_UNKNOWN_7,
	OB_TYPE_EVENT,
	OB_TYPE_EVENT_PAIR,
	OB_TYPE_MUTANT,
	OB_TYPE_UNKNOWN_11,
	OB_TYPE_SEMAPHORE,
	OB_TYPE_TIMER,
	OB_TYPE_PROFILE,
	OB_TYPE_WINDOW_STATION,
	OB_TYPE_DESKTOP,
	OB_TYPE_SECTION,
	OB_TYPE_KEY,
	OB_TYPE_PORT,
	OB_TYPE_WAITABLE_PORT,
	OB_TYPE_UNKNOWN_21,
	OB_TYPE_UNKNOWN_22,
	OB_TYPE_UNKNOWN_23,
	OB_TYPE_UNKNOWN_24,
	OB_TYPE_IO_COMPLETION,
	OB_TYPE_FILE,

}SYSTEM_HANDLE_TYPE,*PSYSTEM_HANDLE_TYPE;


typedef struct _CLIENT_ID 
{
	ULONG UniqueProcess;
	HANDLE UniqueThread;
} CLIENT_ID;

typedef CLIENT_ID *PCLIENT_ID;

typedef struct _PEB_LDR_DATA
{
	ULONG                    Length           ;
	UCHAR                    Initialized      ;
	PVOID                    SsHandle         ;
	struct _LIST_ENTRY       InLoadOrderModuleList;
	struct _LIST_ENTRY       InMemoryOrderModuleList;
	struct _LIST_ENTRY       InInitializationOrderModuleList;
	PVOID                    EntryInProgress ;       
}PEB_LDR_DATA,*PPEB_LDR_DATA;

typedef struct _UNICODE_STRING
{
	USHORT  Length;
	USHORT  MaximumLength;
	WCHAR*  Buffer;
}UNICODE_STRING,*PUNICODE_STRING;

typedef struct _ANSI_STRING
{
	USHORT  Length;
	USHORT  MaximumLength;
	WCHAR*  Buffer;
}ANSI_STRING,*PANSI_STRING;


typedef struct _PEB
{
	UCHAR                                    InheritedAddressSpace ;
	UCHAR                                    ReadImageFileExecOptions ;
	UCHAR                                    BeingDebugged;
	UCHAR                                    SpareBool;
	PVOID                                    Mutant;
	PVOID                                    ImageBaseAddress;
	struct _PEB_LDR_DATA                     Ldr;
	struct _RTL_USER_PROCESS_PARAMETERS*     ProcessParameters;
	PVOID                                    SubSystemData ;
	PVOID                                    ProcessHeap;
	struct _RTL_CRITICAL_SECTION*            FastPebLock;
	PVOID                                    FastPebLockRoutine;
	PVOID                                    FastPebUnlockRoutine;
	ULONG                                    EnvironmentUpdateCount;
	PVOID                                    KernelCallbackTable;
	ULONG                                    SystemReserved[1];
	ULONG                                    AtlThunkSListPtr32;
	struct _PEB_FREE_BLOCK*                  FreeList;
	ULONG                                    TlsExpansionCounter;
	ULONG                                    TlsBitmap;
	ULONG                                    TlsBitmapBits[2];
	PVOID                                    ReadOnlySharedMemoryBase;
	PVOID                                    ReadOnlySharedMemoryHeap;
	PVOID                                    ReadOnlyStaticServerData;
	PVOID                                    AnsiCodePageData;
	PVOID                                    OemCodePageData;
	PVOID                                    UnicodeCaseTableData;
	ULONG                                    NumberOfProcessors;
	ULONG                                    NtGlobalFlag ;
	LARGE_INTEGER                            CriticalSectionTimeout;
	ULONG                                    HeapSegmentReserve;
	ULONG                                    HeapSegmentCommit;
	ULONG                                    HeapDeCommitTotalFreeThreshold;
	ULONG                                    HeapDeCommitFreeBlockThreshold ;
	ULONG                                    NumberOfHeaps    ;
	ULONG                                    MaximumNumberOfHeaps;
	PVOID                                    ProcessHeaps     ;
	PVOID                                    GdiSharedHandleTable ;
	PVOID                                    ProcessStarterHelper;
	ULONG                                    GdiDCAttributeList ;
	PVOID                                    LoaderLock     ;
	ULONG                                    OSMajorVersion ;
	ULONG                                    OSMinorVersion ;
	USHORT                                   OSBuildNumber  ;
	USHORT                                   OSCSDVersion   ;
	ULONG                                    OSPlatformId   ;
	ULONG                                    ImageSubsystem ;
	ULONG                                    ImageSubsystemMajorVersion;
	ULONG                                    ImageSubsystemMinorVersion ;
	ULONG                                    ImageProcessAffinityMask ;
	ULONG                                    GdiHandleBuffer[34];
	PVOID                                    PostProcessInitRoutine ;
	PVOID                                    TlsExpansionBitmap ;
	ULONG                                    TlsExpansionBitmapBits[32];
	ULONG                                    SessionId      ;
	ULARGE_INTEGER                           AppCompatFlags  ;
	ULARGE_INTEGER                           AppCompatFlagsUser ;
	PVOID                                    pShimData     ;
	PVOID                                    AppCompatInfo    ;
	struct _UNICODE_STRING                   CSDVersion       ;
	PVOID                                    ActivationContextData ;
	PVOID                                    ProcessAssemblyStorageMap ;
	PVOID                                    SystemDefaultActivationContextData ;
	PVOID                                    SystemAssemblyStorageMap ;
	ULONG                                    MinimumStackCommit ;

}PEB,*PPEB;

struct __PEB
{
	DWORD   dwFiller[4];
	DWORD   dwInfoBlockAddress;
};

struct __INFOBLOCK
{
	DWORD   dwFiller[16];
	WORD    wLength;
	WORD    wMaxLength;
	DWORD   dwCmdLineAddress;
};


typedef struct _CURDIR
{

	struct _UNICODE_STRING DosPath          ;
	PVOID                  Handle           ;   
}CURDIR,*PCURDIR;

typedef struct _RTL_DRIVE_LETTER_CURDIR
{

	USHORT Flags            ;
	USHORT Length           ;
	ULONG TimeStamp        ;
	ANSI_STRING DosPath    ;       
}RTL_DRIVE_LETTER_CURDIR,*PRTL_DRIVE_LETTER_CURDIR;


typedef struct _RTL_USER_PROCESS_PARAMETERS
{
	ULONG MaximumLength    ;
	ULONG Length           ;
	ULONG Flags            ;
	ULONG DebugFlags       ;
	PVOID ConsoleHandle    ;
	ULONG ConsoleFlags     ;
	PVOID StandardInput    ;
	PVOID StandardOutput   ;
	PVOID StandardError    ;
	struct _CURDIR CurrentDirectory ;
	struct _UNICODE_STRING DllPath          ;
	struct _UNICODE_STRING ImagePathName    ;
	struct _UNICODE_STRING CommandLine      ;
	PVOID  Environment      ;
	ULONG  StartingX        ;
	ULONG StartingY        ;
	ULONG CountX           ;
	ULONG CountY           ;
	ULONG CountCharsX      ;
	ULONG CountCharsY      ;
	ULONG FillAttribute    ;
	ULONG WindowFlags      ;
	ULONG ShowWindowFlags  ;
	struct _UNICODE_STRING WindowTitle      ;
	struct _UNICODE_STRING DesktopInfo      ;
	struct _UNICODE_STRING ShellInfo        ;
	struct _UNICODE_STRING RuntimeData      ;
	struct _RTL_DRIVE_LETTER_CURDIR CurrentDirectores[32] ;

}RTL_USER_PROCESS_PARAMETERS,*PRTL_USER_PROCESS_PARAMETERS;

typedef struct _OBJECT_ATTRIBUTES64 {
	ULONG Length;
	ULONG64 RootDirectory;
	ULONG64 ObjectName;
	ULONG Attributes;
	ULONG64 SecurityDescriptor;
	ULONG64 SecurityQualityOfService;
} OBJECT_ATTRIBUTES64;
typedef OBJECT_ATTRIBUTES64 *POBJECT_ATTRIBUTES64;
typedef CONST OBJECT_ATTRIBUTES64 *PCOBJECT_ATTRIBUTES64;

typedef struct _OBJECT_ATTRIBUTES32 {
	ULONG Length;
	ULONG RootDirectory;
	ULONG ObjectName;
	ULONG Attributes;
	ULONG SecurityDescriptor;
	ULONG SecurityQualityOfService;
} OBJECT_ATTRIBUTES32;
typedef OBJECT_ATTRIBUTES32 *POBJECT_ATTRIBUTES32;
typedef CONST OBJECT_ATTRIBUTES32 *PCOBJECT_ATTRIBUTES32;

typedef struct _OBJECT_ATTRIBUTES {
	ULONG Length;
	HANDLE RootDirectory;
	PUNICODE_STRING ObjectName;
	ULONG Attributes;
	PVOID SecurityDescriptor;        // Points to type SECURITY_DESCRIPTOR
	PVOID SecurityQualityOfService;  // Points to type SECURITY_QUALITY_OF_SERVICE
} OBJECT_ATTRIBUTES;
typedef OBJECT_ATTRIBUTES *POBJECT_ATTRIBUTES;
typedef CONST OBJECT_ATTRIBUTES *PCOBJECT_ATTRIBUTES;


//ÿ½ṹ
typedef struct _SYSTEM_HANDLE
{
	ULONG       ProcessId;
	UCHAR       ObjectTypeNumber;
	UCHAR       Flags;
	HANDLE      Handle;
	PVOID       Object;
	ACCESS_MASK GrantedAccess;
} SYSTEM_HANDLE, *PSYSTEM_HANDLE;

typedef struct _SYSTEM_HANDLE_INFORMATION 
{
	ULONG            uCount;
	SYSTEM_HANDLE    Handles[1];
} SYSTEM_HANDLE_INFORMATION, *PSYSTEM_HANDLE_INFORMATION;

typedef struct _FILE_NAME_INFORMATION
{   
	ULONG FileNameLength;                                   // ntddk
	WCHAR FileName[1];                                      // ntddk
} FILE_NAME_INFORMATION, *PFILE_NAME_INFORMATION;           // ntddk

typedef enum _SYSTEM_INFORMATION_CLASS {
	SystemBasicInformation,
	SystemProcessorInformation,
	SystemPerformanceInformation,
	SystemTimeOfDayInformation,
	SystemNotImplemented1,
	SystemProcessesAndThreadsInformation,
	SystemCallCounts,
	SystemConfigurationInformation,
	SystemProcessorTimes,
	SystemGlobalFlag,
	SystemNotImplemented2,
	SystemModuleInformation,
	SystemLockInformation,
	SystemNotImplemented3,
	SystemNotImplemented4,
	SystemNotImplemented5,
	SystemHandleInformation,
	SystemObjectInformation,
	SystemPagefileInformation,
	SystemInstructionEmulationCounts,
	SystemInvalidInfoClass1,
	SystemCacheInformation,
	SystemPoolTagInformation,
	SystemProcessorStatistics,
	SystemDpcInformation,
	SystemNotImplemented6,
	SystemLoadImage,
	SystemUnloadImage,
	SystemTimeAdjustment,
	SystemNotImplemented7,
	SystemNotImplemented8,
	SystemNotImplemented9,
	SystemCrashDumpInformation,
	SystemExceptionInformation,
	SystemCrashDumpStateInformation,
	SystemKernelDebuggerInformation,
	SystemContextSwitchInformation,
	SystemRegistryQuotaInformation,
	SystemLoadAndCallImage,
	SystemPrioritySeparation,
	SystemNotImplemented10,
	SystemNotImplemented11,
	SystemInvalidInfoClass2,
	SystemInvalidInfoClass3,
	SystemTimeZoneInformation,
	SystemLookasideInformation,
	SystemSetTimeSlipEvent,
	SystemCreateSession,
	SystemDeleteSession,
	SystemInvalidInfoClass4,
	SystemRangeStartInformation,
	SystemVerifierInformation,
	SystemAddVerifier,
	SystemSessionProcessesInformation
} SYSTEM_INFORMATION_CLASS;



typedef struct _IO_STATUS_BLOCK 
{
	union 
	{
		NTSTATUS Status;
		PVOID Pointer;
	};

	ULONG_PTR Information;
} IO_STATUS_BLOCK, *PIO_STATUS_BLOCK;

typedef enum _FILE_INFORMATION_CLASS {
	// end_wdm
	FileDirectoryInformation         = 1,
	FileFullDirectoryInformation,   // 2
	FileBothDirectoryInformation,   // 3
	FileBasicInformation,           // 4  wdm
	FileStandardInformation,        // 5  wdm
	FileInternalInformation,        // 6
	FileEaInformation,              // 7
	FileAccessInformation,          // 8
	FileNameInformation,            // 9
	FileRenameInformation,          // 10
	FileLinkInformation,            // 11
	FileNamesInformation,           // 12
	FileDispositionInformation,     // 13
	FilePositionInformation,        // 14 wdm
	FileFullEaInformation,          // 15
	FileModeInformation,            // 16
	FileAlignmentInformation,       // 17
	FileAllInformation,             // 18
	FileAllocationInformation,      // 19
	FileEndOfFileInformation,       // 20 wdm
	FileAlternateNameInformation,   // 21
	FileStreamInformation,          // 22
	FilePipeInformation,            // 23
	FilePipeLocalInformation,       // 24
	FilePipeRemoteInformation,      // 25
	FileMailslotQueryInformation,   // 26
	FileMailslotSetInformation,     // 27
	FileCompressionInformation,     // 28
	FileObjectIdInformation,        // 29
	FileCompletionInformation,      // 30
	FileMoveClusterInformation,     // 31
	FileQuotaInformation,           // 32
	FileReparsePointInformation,    // 33
	FileNetworkOpenInformation,     // 34
	FileAttributeTagInformation,    // 35
	FileTrackingInformation,        // 36
	FileIdBothDirectoryInformation, // 37
	FileIdFullDirectoryInformation, // 38
	FileValidDataLengthInformation, // 39
	FileShortNameInformation,       // 40
	FileMaximumInformation
	// begin_wdm
} FILE_INFORMATION_CLASS, *PFILE_INFORMATION_CLASS;


typedef struct _PROCESS_BASIC_INFORMATION {
	LONG ExitStatus;
	PVOID PebBaseAddress;
	ULONG AffinityMask;
	LONG BasePriority;
	ULONG UniqueProcessId;
	ULONG InheritedFromUniqueProcessId;
} PROCESS_BASIC_INFORMATION;
typedef PROCESS_BASIC_INFORMATION *PPROCESS_BASIC_INFORMATION;



typedef enum _PROCESSINFOCLASS {
	ProcessBasicInformation,
	ProcessQuotaLimits,
	ProcessIoCounters,
	ProcessVmCounters,
	ProcessTimes,
	ProcessBasePriority,
	ProcessRaisePriority,
	ProcessDebugPort,
	ProcessExceptionPort,
	ProcessAccessToken,
	ProcessLdtInformation,
	ProcessLdtSize,
	ProcessDefaultHardErrorMode,
	ProcessIoPortHandlers,          // Note: this is kernel mode only
	ProcessPooledUsageAndLimits,
	ProcessWorkingSetWatch,
	ProcessUserModeIOPL,
	ProcessEnableAlignmentFaultFixup,
	ProcessPriorityClass,
	ProcessWx86Information,
	ProcessHandleCount,
	ProcessAffinityMask,
	ProcessPriorityBoost,
	ProcessDeviceMap,
	ProcessSessionInformation,
	ProcessForegroundInformation,
	ProcessWow64Information,
	ProcessImageFileName,
	ProcessLUIDDeviceMapsEnabled,
	ProcessBreakOnTermination,
	ProcessDebugObjectHandle,
	ProcessDebugFlags,
	ProcessHandleTracing,
	MaxProcessInfoClass             // MaxProcessInfoClass should always be the last enum
} PROCESSINFOCLASS;

typedef 
NTSTATUS
(__stdcall *NTQUERYINFORMATIONFILE)
(
 IN HANDLE FileHandle,
 OUT PIO_STATUS_BLOCK IoStatusBlock,
 OUT PVOID FileInformation,
 IN ULONG Length,
 IN FILE_INFORMATION_CLASS FileInformationClass
 );

static NTQUERYINFORMATIONFILE NtQueryInformationFile = NULL;

extern "C"
typedef 
NTSYSCALLAPI
LONG 
(__stdcall *NTQUERYINFORMATIONPROCESS)(
							 HANDLE ProcessHandle,
							 PROCESSINFOCLASS ProcessInformationClass,
							 PVOID ProcessInformation,
							 ULONG ProcessInformationLength,
							 PULONG ReturnLength
							 );
NTQUERYINFORMATIONPROCESS   NtQueryInformationProcess = NULL;

typedef 
NTSTATUS 
( __stdcall *ZWQUERYSYSTEMINFORMATION ) 
( IN SYSTEM_INFORMATION_CLASS SystemInformationClass, 
 IN OUT PVOID                SystemInformation, 
 IN ULONG                    SystemInformationLength, 
 OUT PULONG                  ReturnLength OPTIONAL 
 );  

static ZWQUERYSYSTEMINFORMATION ZwQuerySystemInformation = NULL;


typedef
NTSYSCALLAPI
NTSTATUS
(__stdcall *NTOPENPROCESS)
 (
			   OUT PHANDLE ProcessHandle,
			   IN ACCESS_MASK DesiredAccess,
			   IN POBJECT_ATTRIBUTES ObjectAttributes,
			   IN PCLIENT_ID ClientId OPTIONAL
);

static NTOPENPROCESS NtOpenProcess = NULL;


typedef
NTSYSAPI
NTSTATUS
(__stdcall * ZWDUPLICATEOBJECT )
 (
	IN HANDLE       SourceProcessHandle,
	IN HANDLE       SourceHandle,
	IN HANDLE       TargetProcessHandle OPTIONAL,
	OUT PHANDLE     TargetHandle OPTIONAL,
	IN ACCESS_MASK  DesiredAccess,
	IN ULONG        HandleAttributes,
	IN ULONG        Options
);

static  ZWDUPLICATEOBJECT ZwDuplicateObject;




typedef enum _SHUTDOWN_ACTION {
	ShutdownNoReboot,
	ShutdownReboot,
	ShutdownPowerOff
} SHUTDOWN_ACTION, *PSHUTDOWN_ACTION;
 
typedef
NTSYSCALLAPI
NTSTATUS
(__stdcall *NTSHUTDOWNSYSTEM)
(
IN SHUTDOWN_ACTION      Action 
 );
static  NTSHUTDOWNSYSTEM NtShutdownSystem;





#endif


