
//#include <afxwin.h>
//#include <afxtempl.h>
#include <afxwin.h>
#include <atlstr.h>
#include "util.h"
//#include <tchar.h>
//#include <atlstr.h>

//#include <cruntime.h>
//#include <stdio.h>
//#include <dbgint.h>
//#include <stdarg.h>
//#include <internal.h>
//#include <limits.h>
//#include <mtdll.h>
//#include <stddef.h>
#include <cmath>
#include <ctime>
 
#include "kernel.h"
#include <shlobj.h>
#pragma comment(lib,"Userenv.lib")
#pragma comment(lib,"WtsApi32.lib")


#ifdef _DEBUG
#define new DEBUG_NEW
#endif
 
namespace nsYLX
{

	//typedef CMap<HWND, HWND&, CWnd*, CWnd* > HandleMapTable;
	//HandleMapTable    gHandleMapTable;

	CUtil::CUtil(void)
	{
	}

	CUtil::~CUtil(void)
	{
	}
 
	void CUtil::SimpleRunApp(IN TCHAR* sName, IN TCHAR* sPath)
	{
		if ( !sName ||  0==_tcslen(sName))
		{
			return;
		}


		TCHAR* pTchs =  new TCHAR[MAX_PATH*2];
		ZeroMemory(pTchs,sizeof(TCHAR)*MAX_PATH*2);
 
		GenericAbsFullPath(sPath, sName, pTchs, sizeof(TCHAR)*MAX_PATH*2);

		if (!IsFileExists(LPCTSTR(pTchs)))
		{
			delete[] pTchs;pTchs=0;
			return;
		} 

		SHELLEXECUTEINFO ShExecInfo = {0};
		ZeroMemory(&ShExecInfo, sizeof(SHELLEXECUTEINFO));

		ShExecInfo.cbSize = sizeof(SHELLEXECUTEINFO);

		ShExecInfo.fMask = SEE_MASK_NOCLOSEPROCESS;//SEE_MASK_UNICODE|SEE_MASK_CONNECTNETDRV;//
		ShExecInfo.hwnd = NULL;
		ShExecInfo.lpVerb = NULL;
		ShExecInfo.lpFile = pTchs;
		ShExecInfo.lpParameters = _T("");
		ShExecInfo.lpDirectory = NULL;
		ShExecInfo.nShow = SW_SHOWNORMAL;//|SEE_MASK_DOENVSUBST;
		ShExecInfo.hInstApp = NULL;
		ShellExecuteEx(&ShExecInfo);

		WaitForSingleObject(ShExecInfo.hProcess,5000);
 

		delete[] pTchs;pTchs=0;

		return  ;
	}//void ExecApp2()
 
	//////////////////////////////////////////////////////////////////////////  
	//   DelTree  
	//   ɾһļ  
	//   lpszPath   -   Ҫɾļ·  
	//   ֵɹTRUE򷵻FALSE  
	//   עɾļ  
	//ɾļļʽΪx:\\xx\\xx\\x\\*
	//////////////////////////////////////////////////////////////////////////  

	BOOL CUtil::DelTree(LPCTSTR lpszPath)
	{
		SHFILEOPSTRUCT FileOp;
		FileOp.fFlags = FOF_NOCONFIRMATION| FOF_SILENT;
		FileOp.hNameMappings = NULL;
		FileOp.hwnd = NULL;
		FileOp.lpszProgressTitle = NULL;
		FileOp.pFrom = lpszPath;
		FileOp.pTo = NULL;
		FileOp.wFunc = FO_DELETE;
		FileOp.fAnyOperationsAborted = FALSE;
		int nRtn = SHFileOperation(&FileOp);
		if (nRtn !=0)
		{
#ifdef DEBUG
			TCHAR tchs[MAX_PATH];
			nsYLX::CUtil::GetErrorMessage(IN tchs,IN  MAX_PATH);
			_tcscat(tchs,_T("CUtil::DelTree "));
			_tcscat(tchs,lpszPath);
			AfxMessageBox(tchs);
#endif
		}

		return nRtn == 0;
	}

	BOOL CUtil::CopyFileEx(TCHAR *szSrcPathName, TCHAR *szDstPathName)
	{

		TCHAR chSrcPathName[MAX_PATH + 1];
		TCHAR chDstPathName[MAX_PATH + 1];

		memset(chSrcPathName, 0,sizeof(TCHAR)*(MAX_PATH + 1) );
		_tcscpy(chSrcPathName, szSrcPathName);
		nsYLX::CUtil::ChangeRBackSlash(chSrcPathName, _tcslen(chSrcPathName));

		memset(chDstPathName, 0, sizeof(TCHAR)*(MAX_PATH + 1));
		_tcscpy(chDstPathName, szDstPathName);
		nsYLX::CUtil::ChangeRBackSlash(chDstPathName, _tcslen(chDstPathName));

		SHFILEOPSTRUCT fo;
		memset(&fo, 0, sizeof(SHFILEOPSTRUCT));

		fo.wFunc = FO_COPY;
		fo.pFrom = chSrcPathName;
		fo.pTo = chDstPathName;
		fo.fFlags = FOF_NOCONFIRMATION | FOF_SILENT|FOF_MULTIDESTFILES|FOF_NOCONFIRMMKDIR;
 
		fo.fAnyOperationsAborted = FALSE;
		int nRtn = SHFileOperation(&fo);

		if (nRtn !=0)
		{
#ifdef DEBUG
			TCHAR tchs[MAX_PATH*2];
			DWORD dw = GetLastError();
			nsYLX::CUtil::GetErrorMessage(IN tchs,IN  MAX_PATH*2 , dw);
			_tcscat(tchs,_T("CUtil::CopyFileEx "));
			_tcscat(tchs,szSrcPathName);
			AfxMessageBox(tchs);
#endif
		}

		return nRtn == 0;
 
	}

	//ã֧·//Լ\,֧Ƿɾļб
	BOOL CUtil::DeleteDirectory(LPCTSTR DirName)
	{
		//һCFileFind
		CFileFind tempFind;

		//ڶʽ
		TCHAR *tempFileFind=new TCHAR[500];
		_stprintf(tempFileFind,_T("%s*.*"),DirName);

		//ƥʽΪ*.*,Ŀ¼µļ
		BOOL IsFinded=(BOOL)tempFind.FindFile(tempFileFind);

		//ҵһļ
		while(IsFinded)
		{
			IsFinded=(BOOL)tempFind.FindNextFile(); //ݹļ
			if(!tempFind.IsDots())
			{
				//"."Ŀ¼
				TCHAR foundFileName[500];
				ZeroMemory(foundFileName,sizeof(foundFileName));
				_tcscpy(foundFileName,tempFind.GetFileName().GetBuffer(500));

				if(tempFind.IsDirectory())
				{  
					//Ŀ¼ݹص
					//DeleteDirectory
					TCHAR *tempDir=new TCHAR[500];
					_stprintf(tempDir,_T("%s%s"),DirName,foundFileName);
					DeleteDirectory(tempDir);
					delete[] tempDir;
				}
				else
				{
					//ļֱɾ֮
					TCHAR *tempFileName=new TCHAR[500];
					_stprintf(tempFileName,_T("%s%s"),DirName,foundFileName);
					DeleteFile(tempFileName);
					delete[] tempFileName;
				}
			}
		}
		tempFind.Close();

		delete[] tempFileFind;

		if(!RemoveDirectory(DirName)) //ɾĿ¼
		{
			//AfxMessageBox("ɾĿ¼ʧܣ",MB_OK);
			return FALSE;
		}
		return TRUE;
	}



	//ڸļ򴴽ָСĿնļ 
	bool CUtil::GenericEmptyFile(TCHAR* ptchFn, ULONGLONG ullFileSize)
	{
		bool bRtn = false;

		if (!ptchFn || _tcslen(ptchFn)==0 )
		{
			return bRtn;
		}

		if (nsYLX::CUtil::IsFileExists(ptchFn))
		{
			return TRUE;
		}

		HANDLE 
			hFile = CreateFile(
			ptchFn,							// file to open
			GENERIC_WRITE,         // open for reading
			0,									// share for reading
			NULL,								// default security
			CREATE_NEW,							// existing file only
			FILE_ATTRIBUTE_NORMAL,				// normal file
			NULL);								// no attr. template

		if (INVALID_HANDLE_VALUE == hFile)
		{

			return bRtn;
		}

		LARGE_INTEGER lg;
		lg.QuadPart = ullFileSize;

		if( INVALID_SET_FILE_POINTER ==
			SetFilePointerEx(    hFile,
			lg,
			NULL,
			FILE_BEGIN
			)
			)
		{
			;
		}

		SetEndOfFile(hFile);

		CloseHandle(hFile);

		return bRtn;
	}//bool GenericEmptyFile(TCHAR* ptchFn, ULONGLONG ullFileSize)

	//жǷڸļ
	BOOL CUtil::IsFileExists(const TCHAR *ptchs)
	{
		TCHAR* pfn          = new TCHAR[MAX_PATH*2];
		ZeroMemory(pfn,	MAX_PATH*2*sizeof(TCHAR));

 

		_tcscpy(pfn, ptchs);

		//_tcscpy(pfn,_T("\\\\?\\"));
		//_tcscat(pfn,ptchFullPath);

		//ļУʹFILE_FLAG_BACKUP_SEMANTICS 
		//HANDLE hFile= CreateFile(pfn,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL|FILE_FLAG_BACKUP_SEMANTICS ,NULL);
		HANDLE hFile = CreateFile(pfn,                   // pointer to name of the file 
			GENERIC_READ,  //GENERIC_WRITE| access (read-write) mode 
			FILE_SHARE_READ,//FILE_SHARE_READ|FILE_SHARE_WRITE,                           // share mode 
			NULL,                        // pointer to security attributes 
			OPEN_EXISTING,               // how to create
			FILE_ATTRIBUTE_NORMAL|FILE_FLAG_BACKUP_SEMANTICS ,       // file attributes
			NULL );                      // handle to file with attributes to copy

		BOOL bRtn=FALSE;
		if (INVALID_HANDLE_VALUE ==hFile)
		{
			;
		}else
		{
			CloseHandle(hFile);hFile = NULL;
			bRtn=TRUE;
		}
 
		delete[] pfn;pfn=0;	
		return bRtn;
	}

	BOOL CUtil::GetFileSize(IN LPCTSTR lpszFileName, OUT PLARGE_INTEGER lpFileSize)
	{
         BOOL bRtn =FALSE;
		 if (!lpFileSize)
		 {
			 return bRtn;
		 }

		 lpFileSize->QuadPart=0;
 
		 HANDLE hFile =
		 CreateFile(
				  LPCTSTR(lpszFileName),    // file to open
				  GENERIC_READ,          // open for reading
				  FILE_SHARE_READ,       // share for reading
				  NULL,                  // default security
				  OPEN_EXISTING,         // existing file only
				  FILE_ATTRIBUTE_NORMAL, // normal file
				  NULL);                 // no attr. template

		if (INVALID_HANDLE_VALUE == hFile)
		{
			return bRtn;
		}

		bRtn= GetFileSizeEx(hFile,lpFileSize);
		CloseHandle(hFile);

		 return bRtn;
	}//BOOL CUtil::GetFileSize(PLARGE_INTEGER lpFileSize);

	void CUtil::ChangeRBackSlash(IN OUT TCHAR* szCurrentPath, IN int nLen)
	{
		if (!szCurrentPath)
		{
			return;
		}

		for (int i=0;i<nLen;i++)
		{
			if (szCurrentPath[i]==_T('/'))
			{
				szCurrentPath[i]=_T('\\');
			}
		}

	}// void CUtil::ChangeRBackSlash(IN OUT TCHAR* szCurrentPath);

	void CUtil::ToLower(IN OUT TCHAR* szCurrentPath, IN int nLen)
	{
		if (!szCurrentPath)
		{
			return;
		}

		for (int i=0;i<nLen;i++)
		{
			szCurrentPath[i]=_totlower(szCurrentPath[i]); 
		}
	}

	void CUtil::ToUpper(IN OUT TCHAR* szCurrentPath, IN int nLen)
	{
		if (!szCurrentPath)
		{
			return;
		}

		for (int i=0;i<nLen;i++)
		{ 
			szCurrentPath[i]=_totupper(szCurrentPath[i]); 
		}
	}

	void CUtil::ChangeBackSlash(IN OUT TCHAR* szCurrentPath, IN int nLen)
	{
		if (!szCurrentPath)
		{
			return;
		}

		for (int i=0;i<nLen;i++)
		{
			if (szCurrentPath[i]==_T('\\'))
			{
				szCurrentPath[i]=_T('/');
			}
		}

	}// void CUtil::ChangeBackSlash(IN OUT TCHAR* szCurrentPath);

	void CUtil::AddTailBackslash(IN OUT TCHAR* szCurrentPath)
	{
		if (!szCurrentPath)
		{
			return;
		}
 
		int nLen = _tcslen(szCurrentPath);
 
		for (int i=0;i<nLen;i++)
		{
			if (szCurrentPath[i]==_T('\\'))
			{
				szCurrentPath[i]=_T('/');
			}
		}

		if (szCurrentPath[nLen-1]!='/')
		{
			//ǱڵڴԽʣСһ
			szCurrentPath[nLen]='/';
		}

		/*
		for (int i= _tcslen(szCurrentPath)-1;i>=0;i--)
		{
			if (szCurrentPath[i]==_T(':') )
			{
				szCurrentPath[i+1]=_T('/');
				//szCurrentPath[i+2]=_T('\0');
				break;
			}else if(szCurrentPath[i]==_T('\\') || szCurrentPath[i]==_T('/'))
			{
				szCurrentPath[i+1]=_T('\0');
				break;
			}
		}*/

	}//

	void CUtil::GetModulePath(IN OUT TCHAR* ptchCurrPath,IN int nMaxLen,IN HINSTANCE hInst)
	{
		if (!ptchCurrPath)
		{
			return;
		}
		ZeroMemory(ptchCurrPath,nMaxLen*sizeof(TCHAR));

		//GetCurrentDirectory( MAX_PATH, szCurrentPath );
		GetModuleFileName(hInst,ptchCurrPath, nMaxLen - 2); 

		for (int i= _tcslen(ptchCurrPath)-1;i>=0;i--)
		{
			if (ptchCurrPath[i]==_T(':') )
			{
				ptchCurrPath[i+1]=_T('/');
				ptchCurrPath[i+2]=_T('\0');
				break;
			}else if(ptchCurrPath[i]==_T('\\') || ptchCurrPath[i]==_T('/'))
			{
				ptchCurrPath[i+1]=_T('\0');
				break;
			}
		}//for

		CUtil::AddTailBackslash(ptchCurrPath);
	}

	bool CUtil::GenericAbsFullPath(IN const TCHAR* ptchCurrFullPath,IN const TCHAR* ptchFileName,OUT TCHAR* ptchOutBuf, IN const int nOutBufLen)
	{

		if (!ptchFileName || !ptchOutBuf )
		{
			return false;
		}

		TCHAR*             szCurrentPath= new TCHAR[MAX_PATH*4];
		ZeroMemory(szCurrentPath,MAX_PATH*4*sizeof(TCHAR));

		int nLen = 0;
		if (ptchCurrFullPath)
		{
			nLen = min(_tcslen(ptchCurrFullPath), MAX_PATH*4); 
			_tcsncpy(szCurrentPath, ptchCurrFullPath, nLen);
			CUtil::AddTailBackslash(szCurrentPath);
		}else
		{
			CUtil::GetModulePath(IN OUT szCurrentPath,IN MAX_PATH*4);
		}
 
		TCHAR* chsScreenSaveApp= new TCHAR[MAX_PATH*4];
		memset(chsScreenSaveApp,0,MAX_PATH*sizeof(TCHAR)*4);
		_tcscpy(chsScreenSaveApp,szCurrentPath);
		_tcscat(chsScreenSaveApp,ptchFileName);

		nLen = min(nOutBufLen-1, _tcslen(chsScreenSaveApp));
		_tcsncpy(ptchOutBuf, chsScreenSaveApp, nLen);
		ptchOutBuf[nLen] =_T('\0');

		delete[] chsScreenSaveApp;chsScreenSaveApp=0;
		delete[] szCurrentPath;szCurrentPath=0;

		return true;

	}//

	//ɵͷptchsBuf 
	int CUtil::FormatStr(OUT TCHAR* ptchsBuf,IN int nMaxBufSize,IN const char * _Format, ...)
	{
		if (!ptchsBuf)
		{
			return -1;
		}
	 
		//
		char * _Src = new char[nMaxBufSize+2];
		if (!_Src)
		{
			return -1;
		}
		memset(_Src,0,nMaxBufSize+2);
	 
		//οD:\Program Files\Microsoft Visual Studio 8\VC\crt\src\sprintf_s.c
		va_list arglist;
		va_start(arglist, _Format);
		_vsprintf_s_l((char*)_Src, nMaxBufSize, _Format, NULL, arglist);

		va_end(arglist);

		//_SrcתΪTCHAR*
		#ifdef UNICODE 
			//Ҫchar ,תTCHAR,
			WCHAR* pwchOutCnt=new WCHAR[MAX_PATH*2];
			CUtil::MToWBytes
				(
				IN	  (BYTE*)_Src ,
				OUT   pwchOutCnt,
				IN    nMaxBufSize/sizeof(TCHAR)
				);
			_tcscpy(ptchsBuf, pwchOutCnt);
			delete[] pwchOutCnt;pwchOutCnt=0;
		#else
			strcpy(ptchsBuf, _Src); 
		#endif

		delete[] _Src;_Src=0;

		return 0;
	}//int CUtil::FormatStr(OUT TCHAR* ptchsBuf,IN int nMaxBufSize,IN const char * _Format, ...)


	//ɵͷpMulBytes
	int CUtil::WToMBytes
	(
	IN	const WCHAR* pWideChars,
	OUT	BYTE*		 pMulBytes ,
	IN  int			 nMaxLen,
	IN  UINT		 CodePage
	)
	{
		DWORD dwNum = WideCharToMultiByte(CodePage,NULL,pWideChars,-1,NULL,0,NULL,FALSE);

		if (!pMulBytes)
		{
			return -1;
		}

		if (dwNum > nMaxLen)
		{
			dwNum = nMaxLen;
		}

		//memset(pMulBytes,0, dwNum );
		WideCharToMultiByte (CodePage,NULL,pWideChars,-1,(LPSTR)pMulBytes,dwNum,NULL,FALSE);

		pMulBytes[dwNum-1]='\0';
		return dwNum;
	}

	//ɵͷpWideChars
	int CUtil::MToWBytes
	(
	IN	 const BYTE*  pMulBytes ,
	OUT  WCHAR*       pWideChars,
	IN   int          nMaxLen,
	IN   UINT         CodePage
	)
	{ 
		DWORD dwNum = MultiByteToWideChar (CodePage , 0, (LPCSTR)pMulBytes , -1, NULL, 0);

		if(!pWideChars)
		{
			return -1;
		}
		if (dwNum > nMaxLen)
		{
			dwNum = nMaxLen;
		}
		//memset(pWideChars,0,sizeof(WCHAR)*(dwNum));//dwNum

		MultiByteToWideChar (CodePage , 0, (LPCSTR)pMulBytes , -1, pWideChars, dwNum);

		pWideChars[dwNum-1] = L'\0';
		return dwNum;
	}

#if 0

	//ɵͷpMulBytes
	int CUtil::WToMBytes
						(
						IN	const WCHAR* pWideChars,
						OUT	BYTE*  pMulBytes ,IN int     nMaxLen
						 )
	{
	 
		DWORD dwNum = 0;

		dwNum = WideCharToMultiByte(CP_OEMCP,NULL,pWideChars,-1,NULL,0,NULL,FALSE);

	 
		if (!pMulBytes)
		{
			//::MessageBox(NULL,_T("CUtil::WToMBytes"),_T("@Memory alloca for psText faild@SetEbookMenuTableInfo!"),MB_OK);
			return -1;
		}

		if (dwNum > nMaxLen)
		{
			dwNum = nMaxLen;
		}
		memset(pMulBytes,0, dwNum );

		WideCharToMultiByte (CP_OEMCP,NULL,pWideChars,-1,(LPSTR)pMulBytes,dwNum,NULL,FALSE);
		//memset(pMulBytes+dwNum-1,0,(nMaxSize-dwNum));

		pMulBytes[dwNum-1]='\0';
		return dwNum;
	}//int CUtil::WToMBytes


	//ɵͷpWideChars
	int CUtil::MToWBytes
						(
						IN	 const BYTE*  pMulBytes ,
						OUT  WCHAR* pWideChars,
						IN int     nMaxLen
						)
	{ 
		DWORD dwNum = MultiByteToWideChar (CP_ACP , 0, (LPCSTR)pMulBytes , -1, NULL, 0);

	    //DWORD dwErr =  GetLastError();

		if(!pWideChars)
		{
			return -1;
		}
		if (dwNum > nMaxLen)
		{
			dwNum = nMaxLen;
		}
		memset(pWideChars,0,sizeof(WCHAR)*(dwNum));//dwNum
	 
		MultiByteToWideChar (CP_ACP , 0, (LPCSTR)pMulBytes , -1, pWideChars, dwNum);

		//dwErr =  GetLastError();
		//memset(pWideChars+dwNum,0,(nMaxSize-dwNum)*sizeof(WCHAR));

		pWideChars[dwNum-1] =L'\0';
		return dwNum;
	}//int CUtil::MToWBytes

	int CUtil::parseCmdLine( IN TCHAR* tchsCmdLine,OUT TCHAR**& rtn, IN const int rtnMaxCount)
	{ 
		ASSERT(rtn==NULL && rtnMaxCount>0);
		if ( !tchsCmdLine || _tcslen(tchsCmdLine)==0 || rtnMaxCount <= 0)
		{
			return 0;  
		}

		CString strCmdLine(tchsCmdLine);

		strCmdLine = strCmdLine.TrimLeft();
		strCmdLine = strCmdLine.TrimRight();
		strCmdLine =_T(" ")+ strCmdLine+_T(" ") ;

		CString sLookingFor=(_T(" -")),sTail=_T(" ");

		rtn  = new TCHAR*[rtnMaxCount];

		int nStart = 0,nEnd =0,nTmp=0;
		CString sTmp;

		nStart = 0,nEnd =0;
		int i=0;
		while ((nEnd=strCmdLine.Find(sLookingFor, nStart))!=-1   )
		{
			if (nEnd == nStart && nStart !=0)
			{
				break;
			}else if (nEnd == nStart && nStart== 0)
			{   
				nEnd=strCmdLine.Find(sTail, nStart+sLookingFor.GetLength());
				if(nEnd==-1) break;
			}

			sTmp = strCmdLine.Mid(nStart+sLookingFor.GetLength(), nEnd-(nStart+sLookingFor.GetLength()));



			sTmp = sTmp.TrimLeft();
			sTmp = sTmp.TrimRight();

			if (!sTmp.IsEmpty())
			{
				nTmp = _tcslen(sTmp)+1;
				rtn[i] = new TCHAR[nTmp];
				ZeroMemory(rtn[i],nTmp*sizeof(TCHAR));
				_tcscpy(rtn[i],sTmp.GetBuffer(nTmp));sTmp.ReleaseBuffer();
				i++;
			}


			nEnd += sLookingFor.GetLength();
			nStart = nEnd;
		}//while

		nStart = 0,nEnd =0;
		sLookingFor=(_T(" /"));
		while ((nEnd=strCmdLine.Find(sLookingFor, nStart))!=-1)
		{
			if (nEnd == nStart && nStart !=0)
			{
				break;
			}else if (nEnd == nStart && nStart== 0)
			{   
				nEnd=strCmdLine.Find(sTail, nStart+sLookingFor.GetLength());
				if(nEnd==-1) break;
			}

			sTmp = strCmdLine.Mid(nStart+sLookingFor.GetLength(), nEnd-(nStart+sLookingFor.GetLength()));


			sTmp = sTmp.TrimLeft();
			sTmp = sTmp.TrimRight();

			if (!sTmp.IsEmpty())
			{
				nTmp = _tcslen(sTmp)+1;
				rtn[i] = new TCHAR[nTmp];
				ZeroMemory(rtn[i],nTmp*sizeof(TCHAR));
				_tcscpy(rtn[i],sTmp.GetBuffer(nTmp));sTmp.ReleaseBuffer();
				i++;
			}

			nEnd += sLookingFor.GetLength();
			nStart = nEnd;
		}//while

		return i;
	}//void CUtil::parseCmdLine( IN TCHAR* tchsCmdLine,OUT TCHAR**& rtn, IN const int rtnMaxCount)
#endif

//ֵڿհ׷
//tchsCmdLine = pwd '12 34' opcity 90
//rtn[]= pwd 12 34 opcity 90
//ͷڴ棬ҪCScreenWnd::ClearMemForSplit(IN TCHAR **&rtn, IN int rtnCount);
int CUtil::parseCmdLine( IN const TCHAR* pCmdLine,OUT TCHAR**& rtn, IN const int rtnMaxCount)
{
	ATLASSERT(rtn==NULL && rtnMaxCount>0);
	if (!pCmdLine|| rtnMaxCount <= 0)
	{       
		return 0; 
	}

	int nCmdLineLen = _tcslen(pCmdLine);
	if ( nCmdLineLen==0 )
	{
		return 0; 
	}
	nCmdLineLen+=1;

	TCHAR * tchsCmdLine = new TCHAR[nCmdLineLen+1];
	memset(tchsCmdLine,0,(nCmdLineLen+1)*sizeof(TCHAR));
	_tcscpy(tchsCmdLine,pCmdLine);


	tchsCmdLine[nCmdLineLen-1] = _T(' ');

	rtn  = new TCHAR*[rtnMaxCount];
	int nState=0,iPos=0,iCount=0,i=0,j=0,nTmp=0;

	//         /pwd                    '1234'                    /opcity   90
	//հ1    /\ + ؼ  հ2    '"ո+ֵ   հ3
	TCHAR key[MAX_PATH];
	TCHAR val[MAX_PATH];
	do
	{
		switch (nState)
		{
		case 0:
			if (tchsCmdLine[iPos] == _T(' '))
			{
				while(iPos < nCmdLineLen && tchsCmdLine[iPos] == _T(' '))
				{
					iPos++;
				}//հ
			}        

			//հ׷еӦֻֿܣ
			if (tchsCmdLine[iPos] == _T('/') || tchsCmdLine[iPos] == _T('-'))
			{
				nState = 1;//key
				ATLASSERT(i==0);
			}else
			{
				nState = 2;//val
				ATLASSERT(j==0);

				if (tchsCmdLine[iPos] == _T('\'') || tchsCmdLine[iPos] == _T('\"'))
				{
					if (tchsCmdLine[iPos] == _T('\''))
					{
						while(iPos++ < nCmdLineLen && tchsCmdLine[iPos] != _T('\''))
						{
							val[j++] = tchsCmdLine[iPos];
						}
					}
					else if (tchsCmdLine[iPos] == _T('\"'))
					{
						while(iPos++ < nCmdLineLen && tchsCmdLine[iPos] != _T('\"'))
						{
							val[j++] = tchsCmdLine[iPos];
						}
					}

				}else
				{
					val[j++] = tchsCmdLine[iPos];
				}
			}
			break;
		case 1:
			if (tchsCmdLine[iPos] == _T(' '))
			{
				ATLASSERT(i>0);
				key[i++] = _T('\0');i=0;
				//keyrtn
				nTmp = _tcslen(key)+1;
				rtn[iCount] = new TCHAR[nTmp];
				memset(rtn[iCount],0,nTmp*sizeof(TCHAR));
				_tcscpy(rtn[iCount],key);

				iCount++;

				nState = 0;                 
			}else
			{
				key[i++] = tchsCmdLine[iPos];
			}
			break;
		case 2:
			if (tchsCmdLine[iPos] == _T(' '))
			{
				//while(iPos < nCmdLineLen && tchsCmdLine[iPos] == _T(' '))
				//{
				//    iPos++;
				//}//հ

				ATLASSERT(j>0);
				val[j++] = _T('\0');j=0;
				//keyrtn
				nTmp = _tcslen(val)+1;
				rtn[iCount] = new TCHAR[nTmp];
				memset(rtn[iCount],0,nTmp*sizeof(TCHAR));
				_tcscpy(rtn[iCount],val);
				iCount++;

				nState = 0;   
			}
			else
			{
				val[j++] = tchsCmdLine[iPos];
			}

			break;

		}//switch
	} while (iPos++ < nCmdLineLen);

	delete[] tchsCmdLine;
	return iCount;
}//void CScreenWnd::parseCmdLine( IN TCHAR* tchsCmdLine,OUT TCHAR**& rtn, IN const int rtnMaxCount)

void CUtil::ClearMemForSplit(IN TCHAR **&rtn, IN int rtnCount)
{
	//ASSERT(rtn!=NULL && rtnCount>0);
	if (!rtn  || rtnCount<=0)
	{
		return ;
	}
	for (int i=0;i<rtnCount;i++)
	{
		TCHAR* p = rtn[i];
		if (p)
		{
			delete[] p;p=0;
		}

	}
	delete[] rtn;rtn=0;
}

//Ϊ_tcstokĹϵúڶ߳±
int CUtil::Split(OUT TCHAR **&rtn, IN const int rtnMaxCount, IN  TCHAR * szCp, IN TCHAR * tsTag)
{
	ASSERT(rtn==NULL && rtnMaxCount>0);
	if (rtn  || rtnMaxCount<=0 || !szCp || !tsTag)
	{
		return 0;
	}
	int nLen = _tcslen(szCp)+1;

	TCHAR *sz = new TCHAR[nLen];
	ZeroMemory(sz,nLen*sizeof(TCHAR));
	_tcscpy(sz,szCp);

	nLen = (_tcslen(tsTag)+1)*2;
	TCHAR* seps = new TCHAR[nLen];//;
	ZeroMemory(seps, nLen*sizeof(TCHAR)); 

	_tcscpy(seps, tsTag ); 
	TCHAR* token = _tcstok( sz , seps ); 
 
	rtn  = new TCHAR*[rtnMaxCount];
	for (int i=0;i<rtnMaxCount;i++)
	{
		rtn[i] = 0;
	}
	int i=0;
	int nTmp=0;
	TCHAR *p=NULL;
	while( token != NULL )
	{
		if (rtn)
		{
			if (i>=rtnMaxCount)
			{
				break;
			}
			nTmp = _tcslen(token)+1;
			rtn[i] = new TCHAR[nTmp];
			ZeroMemory(rtn[i],nTmp*sizeof(TCHAR));
			_tcscpy(rtn[i],token);
			//rtn[i]=token;
		}	

		token = _tcstok( NULL, seps );

		i++;
	}//
 
	delete[] seps;  
	delete[] sz;
	return i;
}//void CUtil::Split(ATL::CString rtn[],  ATL::CString sz, ATL::CString tsTag)


	void CUtil::GetErrorMessage(IN TCHAR* ptchs,IN int nBufLen,IN DWORD dwLastErr)
	{
		if (!ptchs)
		{
			return ;
		}

		LPTSTR lpBuffer;    
		FormatMessage ( FORMAT_MESSAGE_ALLOCATE_BUFFER  |
		FORMAT_MESSAGE_IGNORE_INSERTS  |
		FORMAT_MESSAGE_FROM_SYSTEM,
		NULL,
		dwLastErr, // ˴룬ͨڳп GetLastError()֮
		LANG_NEUTRAL,
		(LPTSTR) & lpBuffer,
		0 ,
		NULL );
		
		int nLen = min(nBufLen,_tcslen(lpBuffer));
		memcpy((char*)ptchs, (char*)lpBuffer,sizeof(TCHAR)*nLen);
		ptchs[nLen-1]=_T('\0');//

		//  Free the buffer.
		LocalFree (lpBuffer);

	}//void CUtil::GetErrorMessage(TCHAR* ptchs,DWORD dwLastErr)

	void CUtil::GetRandomNum(OUT TCHAR* pBuf,const int nBufLen,const int nCount)
	{
		int nLen = nCount;

		if (nCount<=0)
		{
			nLen=1;
		}else if (nCount>20)
		{
			nLen=20;
		}

		if (!pBuf || nBufLen<=nLen)
		{
			return;
		}

		srand( (unsigned)time( NULL ) );

		double RANGE_MIN = 1;//1e6;
		double RANGE_MAX = pow((double)10,(double)nLen);//1e8-1;

		double n = (((double) rand() / (double) RAND_MAX) * RANGE_MAX + RANGE_MIN);

		_i64tot(n,pBuf,10);
 
	}//void CUtil::GetRandomNum(OUT char* pBuf,int nBufSize, int nCount)

	void CUtil::GenericRandomGUID(OUT TCHAR* pBuf,const int nBufLen)
	{
		if (!pBuf || nBufLen<=0)
		{
			return;
		}
        int nLen = min(38,nBufLen);
		pBuf[nLen] = _T('\0');
		//memset(pBuf,0,(nLen+1)*sizeof(TCHAR));

		::CoInitialize(NULL);
		GUID guid;

		if (S_OK == ::CoCreateGuid(&guid))
		{
			_sntprintf(pBuf, nLen
				,_T("{%08X-%04X-%04x-%02X%02X-%02X%02X%02X%02X%02X%02X}")
				, guid.Data1
				, guid.Data2
				, guid.Data3
				, guid.Data4[0], guid.Data4[1]
			, guid.Data4[2], guid.Data4[3], guid.Data4[4], guid.Data4[5]
			, guid.Data4[6], guid.Data4[7]
			);
		}

		::CoUninitialize();
	}

 	HWND CUtil::CreateHideMsgWindow(WNDPROC procFun, IN LPCTSTR lpszClassName, HWND hParent)
	{
		TCHAR buf[64] = {0};
		ZeroMemory(buf,64*sizeof(TCHAR));

		if (!lpszClassName || _tcslen(lpszClassName)==0)
		{
			::CoInitialize(NULL);
			GUID guid;

			if (S_OK == ::CoCreateGuid(&guid))
			{
				_sntprintf(buf, sizeof(buf)
					,_T("{%08X-%04X-%04x-%02X%02X-%02X%02X%02X%02X%02X%02X}")
					, guid.Data1
					, guid.Data2
					, guid.Data3
					, guid.Data4[0], guid.Data4[1]
				, guid.Data4[2], guid.Data4[3], guid.Data4[4], guid.Data4[5]
				, guid.Data4[6], guid.Data4[7]
				);
			}

			::CoUninitialize();
		}else
		{
			_tcscpy(buf,lpszClassName);
		}

		WNDCLASSEX  windowClass;		 
		MSG			msg;				 
		HINSTANCE   hInstance=0;

		//m_hMutexOneInstantance=CreateMutex(NULL,FALSE,lpszClassName);
		//BOOL   bFound=FALSE;

		//DWORD dwErr= GetLastError();

		//if(dwErr==ERROR_ALREADY_EXISTS)
		//	bFound=TRUE;
		////if(m_hMutexOneInstantance)
		////	ReleaseMutex(m_hMutexOneInstantance);

		//if (bFound==TRUE)
		//{ 
		//	//ֻ֤һʵ
		//	::MessageBox(0,_T("You have Run one"),NULL,MB_OK); 
		//	return 0;
		//}
		//ѾУ򽫽ڴ
		//HWND hWnd = FindWindow(lpszClassName, _T("A Real Win App"));
		//if (IsWindow(hWnd))
		//{
		//	// ǰӴ
		//	// | 0x00000001ڽиǰ̨
		//	// Щڡ
		//	SetForegroundWindow((HWND)((ULONG) hWnd | 0x00000001));
		//	return 0;
		//}

		windowClass.cbSize = sizeof(WNDCLASSEX);
		windowClass.style = CS_HREDRAW | CS_VREDRAW;

		windowClass.lpfnWndProc =  (WNDPROC)procFun;//(WNDPROC)&WndProc;
		windowClass.cbClsExtra = 0;
		windowClass.cbWndExtra = 0;
		windowClass.hInstance = hInstance;
		windowClass.hIcon = LoadIcon(NULL, IDI_APPLICATION);
		windowClass.hCursor = LoadCursor(NULL, IDC_ARROW);
		windowClass.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
		windowClass.lpszMenuName = NULL;
		windowClass.lpszClassName = buf;//_T("MyMsgHiddenWndClass");
		windowClass.hIconSm = LoadIcon(NULL, IDI_WINLOGO);

		if (!RegisterClassEx(&windowClass))
		{
			return 0;
		}

		HWND hwnd=0;
		hwnd = CreateWindowEx(NULL,		 
			buf,//_T("MyMsgHiddenWndClass"),			 
			_T("A Real Win App"),		 
			WS_OVERLAPPEDWINDOW 	 
			//|WS_VISIBLE
			,
			1,1,			 
			40,40,			 
			hParent,				 
			NULL,				//handle to menu
			hInstance,			//(HINSTANCE)this,//application instance
			NULL);				//no extra parameter's

		if (!hwnd)
			return 0;

		//gHandleMapTable.SetAt(hwnd, this);

		return hwnd;
	}


	void CUtil::ExitWindowQuickly()
	{
		CUtil::RaisePrivilege(SE_SHUTDOWN_NAME);
		NtShutdownSystem=
			(NTSHUTDOWNSYSTEM)
			LocateNtdllEntry ( _T("ntdll.dll"), "NtShutdownSystem" );

		TCHAR* pMsg=new TCHAR[MAX_PATH];
		if (!pMsg)
		{
			return ;
		}
		ZeroMemory(pMsg,sizeof(TCHAR)*MAX_PATH);

		if(NtShutdownSystem==NULL)
		{

			_stprintf(pMsg,_T("NtShutdownSystem can't be loaded%d\n"),GetLastError());
			//::MessageBox(NULL,pMsg,_T("LoadDllKernelFun FAILD"),0);
			delete[] pMsg;

			return ;
		}
		NtShutdownSystem(ShutdownPowerOff);	
		delete[] pMsg;

	}

	PVOID CUtil::LocateNtdllEntry (TCHAR* NTDLL_DLL, char* Func )
	{
		HMODULE ntdll_dll   = NULL;
		PVOID   pRtn=0;
		TCHAR* pMsg=new TCHAR[MAX_PATH];
		if (!pMsg)
		{
			return NULL;
		}
		ZeroMemory(pMsg,sizeof(TCHAR)*MAX_PATH);

		if ( ( ntdll_dll = LoadLibrary( NTDLL_DLL ) ) == NULL )
		{
			_stprintf(pMsg,_T("GetModuleHandle() failed%d\n"),GetLastError());
			::MessageBox(NULL,pMsg,_T("LocateNtdllEntry FAILD"),0);
			delete[] pMsg;

			return NULL;
		}

		if ( !( pRtn = ( PVOID )GetProcAddress( ntdll_dll, Func ) ) )
		{
			_stprintf(pMsg,_T("GetProcAddress() failed%d\n"),GetLastError());
			::MessageBox(NULL,pMsg,_T("LocateNtdllEntry FAILD"),0);
		}

		FreeLibrary(ntdll_dll);

		delete[] pMsg;
		return( pRtn );
	}  /* end of LocateNtdllEntry */


	void CUtil::ResumePrivilege(TCHAR *privilegeName)
	{
		HANDLE hToken;
		TOKEN_PRIVILEGES tp;
		LUID luid;

		//ҪӵSE_SHUTDOWN_NAMEȨ
		if ( !OpenProcessToken( GetCurrentProcess(), TOKEN_ALL_ACCESS, &hToken ) )
		{
			//::MessageBox(0, _T( "޷ýȨ!" ) ,_T("ResumePrivilege"),0);
			//TRACE( _T( "޷ýȨ!\0" ));
			return ;
		}

		if ( !LookupPrivilegeValue( NULL, privilegeName/*SE_SHUTDOWN_NAME*/, &luid ) )
		{
			//::MessageBox(0, _T( "ϵͳûȨ!" ) ,_T("ResumePrivilege"),0);
			//TRACE( _T( "ϵͳûȨ!\0" ));
			return ;
		}

		tp.PrivilegeCount = 1;
		tp.Privileges[0].Luid = luid;
		tp.Privileges[0].Attributes = 0; 

		if ( !AdjustTokenPrivileges( hToken, FALSE, &tp, 0, ( PTOKEN_PRIVILEGES )NULL,
			( PDWORD )NULL ) )
		{

			//::MessageBox(0, _T( "Ȩʧ!" ) ,_T("ResumePrivilege"),0);
			//TRACE( _T( "Ȩʧ!\0" ));
			return ;
		}

		CloseHandle( hToken );

	}//void CSetPowerDlg::ResumePrivilege()


	void CUtil::RaisePrivilege(TCHAR *privilegeName)
	{
		HANDLE hToken;
		TOKEN_PRIVILEGES tp;
		LUID luid;

		//ҪӵSE_SHUTDOWN_NAMEȨ
		if ( !OpenProcessToken( GetCurrentProcess(), TOKEN_ALL_ACCESS, &hToken ) )
		{
			//::MessageBox(0, _T( "޷ýȨ!" ) ,_T("ResumePrivilege"),0);
			//TRACE( _T( "޷ýȨ!\0" ));
			return ;
		}

		if ( !LookupPrivilegeValue( NULL, privilegeName/*SE_SHUTDOWN_NAME*/, &luid ) )
		{

			//::MessageBox(0, _T( "ϵͳûȨ!" ) ,_T("ResumePrivilege"),0);
			//TRACE( _T( "ϵͳûȨ!\0" ));
			return ;
		}

		tp.PrivilegeCount = 1;
		tp.Privileges[0].Luid = luid;
		tp.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;

		if ( !AdjustTokenPrivileges( hToken, FALSE, &tp, sizeof( TOKEN_PRIVILEGES ), ( PTOKEN_PRIVILEGES )NULL,
			( PDWORD )NULL ) )
		{

			//::MessageBox(0, _T( "Ȩʧ!" ) ,_T("ResumePrivilege"),0);
			//TRACE( _T( "Ȩʧ!\0" ));
			return ;
		}

		CloseHandle( hToken );
	}//void CSetPowerDlg::RaisePrivilege()


	void CUtil::DllRegisterServer(LPCTSTR lpszDllFullName)
	{
		HINSTANCE _hInstance;
		HRESULT (STDAPICALLTYPE * lpDllEntryPoint)(void);

		char pszDllEntryPoint[] =  "DllRegisterServer";
		LPCTSTR pszDllName = NULL;


		if (!lpszDllFullName || _tcslen(lpszDllFullName)==0)
		{
			return;
		}

		_hInstance = ::GetModuleHandle(NULL);
		// Initialize OLE.
		if (FAILED(OleInitialize(NULL))) 
		{
			return ;
		}

		SetErrorMode(SEM_FAILCRITICALERRORS);       // Make sure LoadLib fails.

		// Load the library.
		HINSTANCE hLib = LoadLibraryEx(lpszDllFullName, NULL, LOAD_WITH_ALTERED_SEARCH_PATH);

		do 
		{
			if (hLib < (HINSTANCE)HINSTANCE_ERROR) 
			{
				break;
			}
			// Find the entry point.
			(FARPROC&)lpDllEntryPoint = GetProcAddress(hLib, pszDllEntryPoint);
			if (lpDllEntryPoint == NULL)
			{
				break;
			}

			// Call the entry point.
			if (FAILED((*lpDllEntryPoint)())) 
			{
				break;
			}
		} while (0);

		if (hLib < (HINSTANCE)HINSTANCE_ERROR) 
		{
			FreeLibrary(hLib);
		}
		OleUninitialize();
	}//DllRegisterServer


	void CUtil::DllUnRegisterServer(LPCTSTR lpszDllFullName)
	{
		HINSTANCE _hInstance;
		HRESULT (STDAPICALLTYPE * lpDllEntryPoint)(void);

		char pszDllEntryPoint[] =  "DllUnRegisterServer";
		LPCTSTR pszDllName = NULL;


		if (!lpszDllFullName || _tcslen(lpszDllFullName)==0)
		{
			return;
		}

		_hInstance = ::GetModuleHandle(NULL);
		// Initialize OLE.
		if (FAILED(OleInitialize(NULL))) 
		{
			return ;
		}

		SetErrorMode(SEM_FAILCRITICALERRORS);       // Make sure LoadLib fails.

		// Load the library.
		HINSTANCE hLib = LoadLibraryEx(lpszDllFullName, NULL, LOAD_WITH_ALTERED_SEARCH_PATH);

		do 
		{
			if (hLib < (HINSTANCE)HINSTANCE_ERROR) 
			{
				break;
			}
			// Find the entry point.
			(FARPROC&)lpDllEntryPoint = GetProcAddress(hLib, pszDllEntryPoint);
			if (lpDllEntryPoint == NULL)
			{
				break;
			}

			// Call the entry point.
			if (FAILED((*lpDllEntryPoint)())) 
			{
				break;
			}
		} while (0);

		if (hLib < (HINSTANCE)HINSTANCE_ERROR) 
		{
			FreeLibrary(hLib);
		}

		OleUninitialize();
	}//DllUnRegisterServer


	//ͨȫ·ƣȶԵǰĿ¼öӦ·
	bool CUtil::GetRelatedName(IN TCHAR* pthsFullName,   OUT TCHAR* ptchsRelated , IN  int nRelatedBufSize, IN TCHAR* ptchsCurrPath)
	{
		bool bRtn = false;
		bool bNeedDelCurrPath =false;
		if (!pthsFullName || !ptchsRelated || nRelatedBufSize<=0)
		{
			return false;
		}

		memset(ptchsRelated,0,nRelatedBufSize);

		if (ptchsCurrPath==0)
		{
			ptchsCurrPath = new TCHAR[MAX_PATH];
			CUtil::GetModulePath(IN OUT ptchsCurrPath,IN   MAX_PATH,IN  NULL);
			bNeedDelCurrPath = true;
		}


		int nSrcLen = _tcslen(pthsFullName);
		int nCurrLen = _tcslen(ptchsCurrPath);

		if (nSrcLen==0 || nCurrLen<3)
		{
			if (bNeedDelCurrPath)
			{
				delete[] ptchsCurrPath;ptchsCurrPath=0;
			}
			return false;
		}

		CUtil::ToLower(IN OUT pthsFullName, IN nSrcLen);
		CUtil::ToLower(IN OUT ptchsCurrPath, IN nCurrLen);


		CUtil::ChangeBackSlash(IN OUT pthsFullName, IN nSrcLen);

		//жϣȫ·ļ͵ǰĿ¼ǲͬͬĻûȡ·ıҪ
		//ʹ״̬ 
		//c : / xx / x.../xx.exe
		//0 1 2 3  2 3   2  4 
		int nState = 0,nPos=0;
		TCHAR* pFull = pthsFullName;
		while (*pFull !=_T('\0'))
		{
            switch(nState)
			{
			case 0:
				if ( !((*pFull >_T('a') && *pFull < _T('z') )|| (*pFull > _T('A') && *pFull < _T('Z') )))
				{
                    goto _BAD;//Ƿַ
				}
				if (*pFull != ptchsCurrPath[0])
				{
					goto _BAD;//ͬĻûȡ·ıҪ
				}
				nState =1;
				break;
			case 1:
				if (*pFull != _T(':'))
				{
					goto _BAD;//Ƿַ
				}
				nState =2;
				break;
			case 2:
				while (*pFull != _T('/') && *pFull!=_T('\0'))
				{
					if (*pFull != ptchsCurrPath[nPos] ||  ptchsCurrPath[nPos]==_T('\0') )
					{
						goto _ENDWHILE;
					}
					pFull++;
					nPos++;
				} 
				break; 
			}
			pFull++;
			nPos++;
		}

		ASSERT(*pFull!= _T('/'));
		//·ĸʽ¼֣
		/*
		/xx/xxx
		./xx/xx
		../../...
		./../...
		*/
_ENDWHILE://;˳WHILEѭ
		int nLevel=0;
		if (nCurrLen <= nPos)
		{
			//ȫ·Ϊǰ·Ŀ¼
			ASSERT(nPos == nCurrLen);
			//ôѰҴpFullʼpthsFullNameм'/'
			while (*pFull && *pFull !=_T('/'))
			{
				pFull--;
				nPos--;
			}
			_tcscpy(ptchsRelated, pFull);//ptchsRelated  /xx/x...ʽ
		}else
		{
			int nTmp  =nPos;
			while (*pFull && *pFull !=_T('/'))
			{
				//˵ַ'/'λ
				pFull--;
				nPos--;
			}
			//ôѰҴnPosʼptchsCurrPathм'/'
			pFull = &ptchsCurrPath[nPos];
			while (*pFull)
			{
				if (*pFull == _T('/'))
				{
					nLevel++;
				}
				pFull++;
			}

			//nLevel..ĸ
			for (int i=0;i<nLevel;i++)
			{
				ptchsRelated[i*3] =_T('.');
				ptchsRelated[i*3+1] =_T('.');
				ptchsRelated[i*3+2] =_T('/');
			}
			pFull = &pthsFullName[nPos];
			_tcscpy(ptchsRelated, pFull+1);//ptchsRelated  ../../......./xx/x...ʽ
		}

_BAD:
		if (bNeedDelCurrPath)
		{
			delete[] ptchsCurrPath;
		}
		return bRtn;
	}


	//ͨ·ƣȶԵǰĿ¼öӦȫ·
	bool CUtil::ParseRelatedName(OUT TCHAR* pthsFullName,  IN  TCHAR* ptchsRelated , IN  int nFullNameBufSize, IN TCHAR* ptchsCurrPath)
	{
		bool bRtn = false;
		bool bNeedDelCurrPath =false;
		if (!pthsFullName || !ptchsRelated)
		{
			return false;
		}

		int nLen = _tcslen(ptchsRelated);
		if (nLen==0)
		{
			return false;
		}
		memset(pthsFullName,0,nFullNameBufSize);

		if (ptchsCurrPath==0)
		{
			ptchsCurrPath = new TCHAR[MAX_PATH];
			CUtil::GetModulePath(IN OUT ptchsCurrPath,IN   MAX_PATH,IN  NULL);
			bNeedDelCurrPath = true;
		}


		TCHAR* pFile = ptchsRelated;
		int nPos =0;
		if (pFile[0]==_T('.') && pFile[1] == _T('/'))
		{
			//pFile = pFile +2;
			nPos +=2;
		}else if ( pFile[0] == _T('/'))
		{
			//pFile = pFile +1;
			nPos +=1;
		}

		//../Ĵ
		int nLevel =0;
		for (int i= nPos ;i<nLen-2;i++)
		{
			if (  pFile[i]==_T('.')
				&&pFile[i+1]==_T('.')
				&&pFile[i+2]==_T('/')
				)
			{
				nLevel++;
				i+=2;
			}
		}//for

		GetParentPath(IN ptchsCurrPath, OUT pthsFullName, IN  nFullNameBufSize, IN  nLevel);

		_tcscat(pthsFullName, &ptchsRelated[nPos+3*nLevel]);

		if (bNeedDelCurrPath)
		{
			delete[] ptchsCurrPath;
		}
		return true;
	}

	int CUtil::GetParentPath(IN const TCHAR* ptchsPath, OUT TCHAR* pOutPath, IN int nOutPathSize, IN int nLevel)
	{
		int nRtn =0;
		if (!ptchsPath)
		{
			return nRtn;
		}

		int nLen = _tcslen(ptchsPath);
		if (0==nLen || !pOutPath || nOutPathSize<=0 || nLevel<0)
		{
			return 0;
		}

		TCHAR *pTchsTmp = new TCHAR[nLen+1];
		ZeroMemory(pTchsTmp, (nLen+1)*sizeof(TCHAR));
		_tcscpy(pTchsTmp, ptchsPath);

		ChangeBackSlash(pTchsTmp, nLen);

		int nTmp = _tcslen(pTchsTmp);

		int nIndex  = nTmp-1;
		for (int i= nTmp-1;i>=0;i--)
		{
			if (pTchsTmp[i] == _T('/'))
			{
				if (nLevel-- == 0)
				{
					nIndex  = i;
					break;
				}
			}
		}

		ZeroMemory(pOutPath, nOutPathSize);
		_tcsncpy(pOutPath,pTchsTmp, nIndex+1);

		nRtn = nIndex+1;

		delete[] pTchsTmp;

		return nRtn;
	}//

	BOOL CUtil::ReleaseResourceToDsk( IN TCHAR* nResId, IN TCHAR* nResType, IN TCHAR* ptchDesFullPath ,IN HMODULE hModule)
	{
		DWORD dwResFileSize = 0;
		PVOID pResData = 0;
		BOOL bRtn = FALSE;

		//ʱĵʼ޷if (CUtil::IsFileExists(ptchDesFullPath))
		//{
		//    return TRUE;
		//}

		// load file from resources...
		HRSRC hRsrc = FindResource( hModule/*AfxGetResourceHandle()*/, nResId, nResType );

		if ( NULL == hRsrc )
		{
			//TRACE( "ERROR: Couldn't locate UsbFilter.sys driver in resources!\n" );
			return bRtn;
		}

		dwResFileSize = SizeofResource( hModule, hRsrc );

		if ( 0 == dwResFileSize )
		{
			//TRACE( "ERROR: Size of UsbSnoop image is 0!\n" );
			return bRtn;
		}

		HGLOBAL hUsbSnoop = LoadResource( hModule, hRsrc );

		if ( NULL == hUsbSnoop )
		{
			//TRACE( "ERROR: Couldn't load UsbFilter.sys driver from resources!\n" );
			return bRtn;
		}

		pResData = LockResource( hUsbSnoop );

		if ( NULL == pResData )
		{
			//TRACE( "ERROR: Couldn't lock UsbFilter.sys driver from resources!\n" );
			return bRtn;
		}

		HANDLE hTmpFile = CreateFile( ptchDesFullPath, GENERIC_WRITE, 0, NULL, OPEN_ALWAYS/*CREATE_ALWAYS*/, FILE_ATTRIBUTE_NORMAL, NULL );
		DWORD dwErr=GetLastError();
		if (dwErr != ERROR_ALREADY_EXISTS)
		{
 			if ( INVALID_HANDLE_VALUE != hTmpFile )
			{
				//ļڣҲд
				DWORD dwWritten = 0;

				if ( !WriteFile( hTmpFile, pResData, dwResFileSize, &dwWritten, NULL ) || ( dwWritten != dwResFileSize ) )
				{
					DeleteFile( ptchDesFullPath );
				}else
				{
					bRtn = TRUE;
				} 
			}
		}

		if ( INVALID_HANDLE_VALUE != hTmpFile )
		{
			CloseHandle( hTmpFile );
		}
		return bRtn;
	}//BOOL CUtil::ReleaseResourceToDsk(IN TCHAR* nResId,IN TCHAR* nResType,IN TCHAR* ptchDesFullPath)
	

	bool CUtil::IsShorcutExists(IN TCHAR* lpszExeFullName,IN  TCHAR* lpszLnkName,IN  TCHAR* lpszLnkPath)
	{
		USES_CONVERSION;       // תΪ UNICODE ַ
		::CoInitialize( NULL );
		bool bExists = false;

		IShellLink * psl = NULL;
		IPersistFile * ppf = NULL;

		HRESULT hr = ::CoCreateInstance(  // 
			CLSID_ShellLink,      // ݷʽ CLSID
			NULL,                 // ۺ(ע4)
			CLSCTX_INPROC_SERVER, // (Shelldll)
			IID_IShellLink,       // IShellLink  IID
			(LPVOID *)&psl );     // õӿָ
		do 
		{
			if ( !SUCCEEDED(hr) )
			{
				break;
			}
			psl->SetPath( lpszExeFullName );  // ȫ·

			//  EXE ļõĿ¼
			TCHAR szWorkPath[ MAX_PATH ];
			memset(szWorkPath,0,MAX_PATH*sizeof(TCHAR));
			::lstrcpy( szWorkPath, lpszExeFullName );
			PathRemoveFileSpec(szWorkPath); 

			//  EXE ĬϹĿ¼
			psl->SetWorkingDirectory( szWorkPath );

			hr = psl->QueryInterface(  // ҳļӿָ
				IID_IPersistFile,      // Խӿ IID
				(LPVOID *)&ppf );      // õӿָ

			if ( !SUCCEEDED(hr) )
			{
				break;
			}

			TCHAR *lpszFullTarget= new TCHAR[MAX_PATH];
			memset(lpszFullTarget,0,MAX_PATH*sizeof(TCHAR));
			if (lpszLnkPath==0)
			{
				SHGetSpecialFolderPath(NULL,lpszFullTarget,CSIDL_DESKTOP,0);

			}else
			{
				_tcscpy(lpszFullTarget,lpszLnkPath);
			}
			nsYLX::CUtil::AddTailBackslash(lpszFullTarget);
			_tcscat(lpszFullTarget,lpszLnkName);

			hr = ppf->Load( T2COLE( lpszFullTarget ), STGM_READWRITE );  // 

			delete[] lpszFullTarget;

			if ( !SUCCEEDED(hr) )
			{
				break;
			}
			bExists = true;

		} while (0);

		if ( ppf )  ppf->Release();
		if ( psl )  psl->Release();

		::CoUninitialize();
		return bExists;

	}//IsShorcutExists

	void CUtil::BuildShortcut(IN TCHAR* lpszExeFullName,IN  TCHAR* lpszLnkName,IN  TCHAR* lpszLnkPath, int nCreate)
	{
		USES_CONVERSION;       // תΪ UNICODE ַ

		// ݷʽ
		//  lpszExe: EXE ļȫ·
		//  lpszLnk: ݷʽļȫ·
		::CoInitialize( NULL );

		IShellLink * psl = NULL;
		IPersistFile * ppf = NULL;

		HRESULT hr = ::CoCreateInstance(  // 
										CLSID_ShellLink,      // ݷʽ CLSID
										NULL,                 // ۺ(ע4)
										CLSCTX_INPROC_SERVER, // (Shelldll)
										IID_IShellLink,       // IShellLink  IID
										(LPVOID *)&psl );     // õӿָ
		do 
		{
			if ( !SUCCEEDED(hr) )
			{
				break;
			}

			psl->SetPath( lpszExeFullName );  // ȫ·
			//      psl->SetArguments();      // в
			//      psl->SetDescription();    // ע
			//      psl->SetHotkey();         // ݼ
			//      psl->SetIconLocation();   // ͼ
			//      psl->SetShowCmd();        // ڳߴ

			//  EXE ļõĿ¼
			TCHAR szWorkPath[ MAX_PATH ];
			memset(szWorkPath,0,MAX_PATH*sizeof(TCHAR));
			::lstrcpy( szWorkPath, lpszExeFullName );
			PathRemoveFileSpec(szWorkPath); 

			//  EXE ĬϹĿ¼
			psl->SetWorkingDirectory( szWorkPath );

			hr = psl->QueryInterface(  // ҳļӿָ
				IID_IPersistFile,      // Խӿ IID
				(LPVOID *)&ppf );      // õӿָ

			if ( !SUCCEEDED(hr) )
			{
				break;
			}

			TCHAR *lpszFullTarget= new TCHAR[MAX_PATH];
			memset(lpszFullTarget,0,MAX_PATH*sizeof(TCHAR));
			if (!lpszLnkPath)
			{
				SHGetSpecialFolderPath(NULL,lpszFullTarget,CSIDL_DESKTOP,0);

			}else
			{
				_tcscpy(lpszFullTarget,lpszLnkPath);
			}
			nsYLX::CUtil::AddTailBackslash(lpszFullTarget);
			_tcscat(lpszFullTarget,lpszLnkName);

			if (nCreate==1)
			{
				ppf->Save( T2COLE( lpszFullTarget ), TRUE );  // 
			}else
			{
				CUtil::DeleteLink(lpszFullTarget);
			}


			delete[] lpszFullTarget;

		} while (0);
				
		if ( ppf )  ppf->Release();
		if ( psl )  psl->Release();

		::CoUninitialize();
	}//CreateShortcut

	BOOL CUtil::DeleteLink( TCHAR* lpszShortcut)
	{
		SHFILEOPSTRUCT fos ;

		ZeroMemory( &fos, sizeof(fos)) ;
		fos.hwnd = HWND_DESKTOP ;
		fos.wFunc = FO_DELETE ;
		fos.pFrom = lpszShortcut;
		fos.pTo = NULL ;
		fos.fFlags = FOF_SILENT | FOF_ALLOWUNDO|FOF_NOCONFIRMATION;
		//ɾݷʽ*.lnk)
		if( 0 != SHFileOperation( &fos))
			return FALSE ;
		return TRUE ;
	}
	// ֪ͨshellйر仯
	void CUtil::NotifyShell(LONG wEventId,//¼־
		TCHAR* szPath)//·
	{   
		SHChangeNotify( wEventId,
			SHCNF_FLUSH | SHCNF_PATH,
			szPath,0);
		//ȡszPathĸĿ¼
		TCHAR* p;
		for( p=szPath+ _tcslen(szPath)-1;
			*p != '\\';
			p--);
		*p='\0';
		SHChangeNotify(SHCNE_UPDATEDIR
			|SHCNE_INTERRUPT,
			SHCNF_FLUSH | SHCNF_PATH,szPath,0);
	}
	
	BOOL CUtil::IsAutoRun(IN const TCHAR* ptchKey)
	{
		BOOL bRtn = false;

		if (!ptchKey)
		{
			return bRtn;
		}

		HKEY hKey;
		// 򿪼
		if(RegOpenKey(HKEY_LOCAL_MACHINE, _T("Software\\Microsoft\\Windows\\CurrentVersion\\Run"), &hKey) !=ERROR_SUCCESS)
			return bRtn;


		long  lRtn = -1;

		do 
		{
			TCHAR  tchsVal[MAX_PATH];
			memset(tchsVal,0,MAX_PATH*sizeof(TCHAR));

			DWORD dwtype;
			DWORD valSize = MAX_PATH;

			lRtn=RegQueryValueEx(
				hKey,					// handle of key to query 
				ptchKey,				//LPTSTR lpValueName,	// address of name of value to query 
				0,						//LPDWORD lpReserved,	// reserved 
				&dwtype,				//LPDWORD lpType,	// address of buffer for value type 
				NULL,//(LPBYTE)tchsVal,	        //LPBYTE lpData,	// address of data buffer 
				NULL//(LPDWORD) &valSize		//LPDWORD lpcbData 	// address of data buffer size 
				);

			if( lRtn != ERROR_SUCCESS )
			{
				//ü
				bRtn  = FALSE;
				break;
			}
			bRtn = TRUE;
		}while(0);

		RegCloseKey(hKey);
		return bRtn;
	}

	BOOL CUtil::SetAutoRun(const BOOL bEnable,IN const TCHAR* ptchKey, IN const TCHAR* ptchFile)
	{
		BOOL bRtn = false;

		if (!ptchKey)
		{
			return bRtn;
		}

		int nLen = 0;

		if (bEnable)
		{
			if (!ptchFile )
			{
				return bRtn;
			}

			nLen = _tcslen(ptchFile);
			if (nLen==0)
			{
				return bRtn;
			}
		}

		HKEY hKey;
		// 򿪼
		if(RegOpenKey(HKEY_LOCAL_MACHINE, _T("Software\\Microsoft\\Windows\\CurrentVersion\\Run"), &hKey) !=ERROR_SUCCESS)
			return bRtn;
			
		long  lRtn = -1;

		do 
		{
			TCHAR  tchsVal[MAX_PATH];
			memset(tchsVal,0,MAX_PATH*sizeof(TCHAR));

			DWORD dwtype;
			DWORD valSize = MAX_PATH;

 
			lRtn=RegQueryValueEx(
				hKey,					// handle of key to query 
				ptchKey,				//LPTSTR lpValueName,	// address of name of value to query 
				0,						//LPDWORD lpReserved,	// reserved 
				&dwtype,				//LPDWORD lpType,	// address of buffer for value type 
				(LPBYTE)tchsVal,	        //LPBYTE lpData,	// address of data buffer 
				(LPDWORD) &valSize		//LPDWORD lpcbData 	// address of data buffer size 
				);

			if( lRtn != ERROR_SUCCESS )
			{
				if (bEnable)
				{
					lRtn=RegSetValueEx(hKey, ptchKey, 0, REG_SZ, (BYTE*)ptchFile, nLen*sizeof(TCHAR));
				}else
				{
					//üڣȻɾˡ					
				}
				break;
			} 

			if(bEnable) //ʱ,üֵ
			{
				if (_tcsicmp(tchsVal,ptchFile)==0)
				{
					break;
				}

				lRtn=RegSetValueEx(hKey, ptchKey, 0, REG_SZ, (BYTE*)ptchFile, nLen*sizeof(TCHAR));
			}
			else //ɾֵ
			{
				lRtn=RegDeleteValue(hKey, ptchKey);
			}

		} while (0);

		if (lRtn == ERROR_SUCCESS)
		{
			bRtn = TRUE;
		}

		RegCloseKey(hKey);
		
		return bRtn;
	}

}//namespace nsYlx


