#include "StdAfx.h"
#include "SerialBuffer.h"
#include <Math.h>
#include <cassert>


#include "../ylxUtil/NsLock.h"
#include "../ylxUtil/Net.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

namespace nsGlusComm
{
	//void CStruc2Str::ToString(OUT char* pOutBuf,OUT int nLen)
	//{
	//	memcpy(pOutBuf,this,sizeof());
	//}//

	//void CStruc2Str::FromString(IN char* pInBuf,IN int nBufSize)
	//{

	//}//


	CHeaderBuffer::CHeaderBuffer(void):m_nTOTALSIZE(HBUF_HDR_SIZE)
	{
		m_nCntLen=0;

		//ʼڴд
		InitializeCriticalSection(&m_Criti);

		m_pReadPtr=m_pWritePtr = m_pBase = NULL;
		m_nMemCapacity=0;
 
		//m_vtNextSBuf = new std::vector<CHeaderBuffer*>();

		//õϵͳ
		m_dwGran = 0;

		SYSTEM_INFO SysInfo;
		GetSystemInfo(&SysInfo);
		m_dwGran = SysInfo.dwAllocationGranularity;
		ReAllocateBuffer(m_dwGran);//1024

		//ܳȵڴͷλ
		UpdateBufferLen(HBUF_HDR_SIZE+HBUF_IPADDR_LEN+HBUF_TYPEID_SIZE);//ȼm_nCntLen = HBUF_HDR_SIZE+HBUF_TYPEID_SIZE;
		CopyMemory(m_pBase,&m_nCntLen,sizeof(m_nCntLen));

		ResetPtr(m_pWritePtr);//дָƵHBUF_HDR_SIZE+HBUF_IPADDR_LEN+HBUF_TYPEID_SIZE
		ResetPtr(m_pReadPtr);//



	}



	//pData,߱CHeaderBufferڴHBUF_HDR_SIZE,HBUF_TYPEID_SIZE,content...ڴ沼 
	CHeaderBuffer::CHeaderBuffer(BYTE* pData, int nLen):m_nTOTALSIZE(HBUF_HDR_SIZE)
	{
		//ʼڴд
		InitializeCriticalSection(&m_Criti);

		m_pReadPtr=m_pWritePtr = m_pBase = NULL;
		m_nMemCapacity=0;
 
		//m_vtNextSBuf = new std::vector<CHeaderBuffer*>();

		//õϵͳ
		m_dwGran = 0;

		SYSTEM_INFO SysInfo;
		GetSystemInfo(&SysInfo);
		m_dwGran = SysInfo.dwAllocationGranularity;

		m_nMemCapacity=nLen;
		ReAllocateBuffer(m_nMemCapacity);//1024

		//ܳȵڴͷλ
		UpdateBufferLen(nLen);//ȼm_nCntLen = m_nMemCapacity
		
		//CopyMemory(m_pBase,&m_nCntLen,sizeof(m_nCntLen));		
		//memset(m_pData,0,m_nMemCapacity);
		memcpy(m_pBase,	pData,			nLen);

		ResetPtr(m_pWritePtr);//дָƵHBUF_HDR_SIZE+HBUF_TYPEID_SIZE
		ResetPtr(m_pReadPtr);//

	}//CHeaderBuffer::CHeaderBuffer(int nLen,char* pData);

	CHeaderBuffer::~CHeaderBuffer(void)
	{
		//for (int i=m_vtNextSBuf->size()-1;i>=0;i--)
		//{
		//	delete (*m_vtNextSBuf)[i];
		//}//for

		//delete m_vtNextSBuf;m_vtNextSBuf=0;
		if (m_pBase)
			VirtualFree(m_pBase,0,MEM_RELEASE);


		DeleteCriticalSection(&m_Criti);
	}

	CHeaderBuffer::CHeaderBuffer(const CHeaderBuffer& other):m_nTOTALSIZE(HBUF_HDR_SIZE)
	{
		m_nMemCapacity = other.m_nMemCapacity;
 
	}//

	CHeaderBuffer& CHeaderBuffer::operator=(const CHeaderBuffer& other)
	{
		if (this != &other)
		{
			ReAllocateBuffer(other.m_nMemCapacity);
 
			m_pReadPtr	= other.m_pReadPtr;
			m_pWritePtr = other.m_pWritePtr;
			m_nCntLen	= other.m_nCntLen;
		}
		return *this;
	}

	void CHeaderBuffer::UpdateBufferLen(ULONGLONG n)
	{
		//ܳȸµBUFָλãBUFͷܳȰHBUF_HDR_SIZE+HBUF_TYPEID_SIZE+ݳ
		nsHelper::CNsLock singleLock(&m_Criti);
		singleLock.Lock();
		m_nCntLen = n;
		CopyMemory(m_pBase,&m_nCntLen,sizeof(m_nCntLen));
		singleLock.Unlock();
	}

	void CHeaderBuffer::ClearBuffer()
	{
		ULONGLONG ull = DeAllocateBuffer(m_dwGran);

		memset(m_pBase,0,ull);

		//ܳȵڴͷλ
		m_nCntLen = HBUF_HDR_SIZE+HBUF_IPADDR_LEN+HBUF_TYPEID_SIZE;

		nsHelper::CNsLock singleLock(&m_Criti);
		singleLock.Lock();

		CopyMemory(m_pBase,&m_nCntLen,sizeof(m_nCntLen));

		singleLock.Unlock();

		seek(m_pWritePtr, HBUF_HDR_SIZE+HBUF_IPADDR_LEN+HBUF_TYPEID_SIZE);
		seek(m_pReadPtr,  HBUF_HDR_SIZE+HBUF_IPADDR_LEN+HBUF_TYPEID_SIZE);
	}

	ULONGLONG CHeaderBuffer::insert(PBYTE pData, ULONGLONG nSize, ULONGLONG nPos)
	{
		ReAllocateBuffer(nSize + HBUF_HDR_SIZE+ HBUF_IPADDR_LEN+HBUF_TYPEID_SIZE+GetBufferLen());

		//ݺŲ
		MoveMemory(m_pBase+nPos+nSize, m_pBase+nPos, GetMemSize() - nSize);
 
 
		if (nPos != HBUF_HDR_SIZE+HBUF_IPADDR_LEN+HBUF_TYPEID_SIZE)
		{
			seek(m_pWritePtr, nPos);
		}

		return Write( pData,  nSize);

	}//BOOL CHeaderBuffer::Insert(PBYTE pData, ULONGLONG nSize);

	ULONGLONG CHeaderBuffer::Insert(PBYTE pData, ULONGLONG nSize, ULONGLONG nPos)
	{

		return insert( pData,  nSize,  HBUF_HDR_SIZE+ HBUF_IPADDR_LEN+HBUF_TYPEID_SIZE+nPos);

	}//ULONGLONG CHeaderBuffer::Insert(PBYTE pData, ULONGLONG nSize, ULONGLONG nPos)




	ULONGLONG CHeaderBuffer::ReAllocateBuffer(ULONGLONG nRequestedSize)
	{
		//if (nRequestedSize < GetMemSize())
		//	return 0;

		//DWORD nNewSize = dwRequesstedSize&~(m_dwGran-1);//(ULONGLONG) ceil(nRequestedSize / 1024.0) * 1024;
		ULONGLONG nNewSize = ((ULONGLONG)(nRequestedSize/m_dwGran))*m_dwGran +  (((nRequestedSize%m_dwGran) > 0 )?m_dwGran:0);
		ULONGLONG nBufferLen = GetBufferLen();

		if (nNewSize <= GetMemSize())
		{
			//ֻڴģǸı䣬̵أ
			return nNewSize;
		}

		nsHelper::CNsLock singleLock(&m_Criti);
		singleLock.Lock();

		PBYTE pNewBuffer = (PBYTE) VirtualAlloc(NULL,nNewSize,MEM_COMMIT,PAGE_READWRITE);



		if (m_pBase)
		{
			MoveMemory(pNewBuffer,m_pBase,nBufferLen);
			VirtualFree(m_pBase,0,MEM_RELEASE);
		}



		m_pBase = pNewBuffer;
		m_pWritePtr = m_pBase + nBufferLen;
		m_nMemCapacity = nNewSize;
		
		CopyMemory(m_pBase,&nNewSize,sizeof(nNewSize));

		singleLock.Unlock();

		return m_nMemCapacity;
	}//

	ULONGLONG CHeaderBuffer::DeAllocateBuffer(ULONGLONG nRequestedSize)
	{
		//if (nRequestedSize < GetBufferLen())
		//	return 0;

 		ULONGLONG nNewSize = ((ULONGLONG)(nRequestedSize/m_dwGran))*m_dwGran +  (((nRequestedSize%m_dwGran) > 0 )?m_dwGran:0);
		//nRequestedSize&~(m_dwGran-1);//(ULONGLONG) ceil(nRequestedSize / 1024.0) * 1024;

		if (nNewSize > GetMemSize())
			return 0;

		if (nNewSize< m_dwGran)
		{
			nNewSize = m_dwGran;
		}
 
		PBYTE pNewBuffer = (PBYTE) VirtualAlloc(NULL,nNewSize,MEM_COMMIT,PAGE_READWRITE);

		ULONGLONG nBufferLen = GetBufferLen();

		nsHelper::CNsLock singleLock(&m_Criti);
		singleLock.Lock();

		nBufferLen = (nBufferLen<nRequestedSize)?nBufferLen:nRequestedSize;

		MoveMemory(pNewBuffer, m_pBase, nBufferLen);

		VirtualFree(m_pBase,0,MEM_RELEASE);

		m_pBase = pNewBuffer;
		m_pWritePtr = m_pBase + nBufferLen;
		m_nMemCapacity = nNewSize;
		
		CopyMemory(m_pBase,&nNewSize,sizeof(nNewSize));

		singleLock.Unlock();

		return m_nMemCapacity;
	}

	ULONGLONG CHeaderBuffer::GetBufferLen() 
	{
		if (m_nCntLen< HBUF_HDR_SIZE+HBUF_IPADDR_LEN+HBUF_TYPEID_SIZE )
		{
			m_nCntLen = HBUF_HDR_SIZE+HBUF_IPADDR_LEN+HBUF_TYPEID_SIZE;
			return m_nCntLen;
		}

		//ȡʱֻȴ䲿ֻ֣ͨǰֵڴָƫƴ׼ȷĻøڴСܲñķʽ
		if (m_pBase)
		{
			CopyMemory(&m_nCntLen,m_pBase,sizeof(m_nCntLen));
		}else
		{
			m_nCntLen = 0;
		}


		return m_nCntLen;
	}

	ULONGLONG CHeaderBuffer::ToString(BYTE* pOut,ULONGLONG nPos)  
	{
		ULONGLONG nOldBufferLen  = GetBufferLen()-nPos;
		if (!pOut)
		{
			return nOldBufferLen;
		}
		nsHelper::CNsLock singleLock(&m_Criti);
		singleLock.Lock();

		MoveMemory/*CopyMemory*/(pOut,m_pBase+nPos,nOldBufferLen);

		singleLock.Unlock();

		return nOldBufferLen;
	}

	ULONGLONG CHeaderBuffer::FromString(BYTE* pIn, ULONGLONG nLen )
	{
		if (!pIn)
		{
			return 0;
		}
				
		ReAllocateBuffer(nLen);

		UpdateBufferLen(nLen);

		MoveMemory(m_pBase, pIn, nLen);
		seek(m_pWritePtr, nLen);//ָƵļβ
		ResetPtr(m_pReadPtr);//
		return nLen;
	}//


	PBYTE CHeaderBuffer::getbuffer(ULONGLONG nPos)
	{
		return m_pBase+nPos;
	}

	PBYTE CHeaderBuffer::GetBuffer(ULONGLONG nPos)
	{
		return getbuffer(HBUF_HDR_SIZE+HBUF_IPADDR_LEN+HBUF_TYPEID_SIZE+nPos);
	}

	int CHeaderBuffer::seek(PBYTE& ptr, int nPos)
	{
		int nCurr = nPos;
		if (nCurr>GetMemSize())
		{
			return 0;
		}
		ptr = m_pBase + nCurr;

		return nCurr;
	}//int CHeaderBuffer::seek(int nPos)

	int CHeaderBuffer::Seek(PBYTE& ptr, int nPos)
	{
		int nCurr = HBUF_HDR_SIZE+HBUF_IPADDR_LEN+HBUF_TYPEID_SIZE+nPos;
		if (nCurr>GetMemSize())
		{
			return HBUF_HDR_SIZE+HBUF_IPADDR_LEN+HBUF_TYPEID_SIZE;
		}
		ptr = m_pBase + nCurr;

		return nCurr;
	}//int CHeaderBuffer::Seek(int nPos)

	void CHeaderBuffer::Copy(CHeaderBuffer& buffer)
	{
		//int nReSize = buffer.GetMemSize();
		//int nSize = buffer.GetBufferLen();
		//ClearBuffer();
		//ReAllocateBuffer(nReSize);

		//UpdateBufferLen(nSize);

		//CopyMemory(m_pBase,buffer.getbuffer(0),buffer.GetBufferLen());
		//seek(m_pWritePtr, nSize);//ָƵļβ

	}//


	//ַͷŶӦڴ,ͷŵַpOut
	bool CHeaderBuffer::Cut(PBYTE pOut, ULONGLONG nLen, ULONGLONG nPos)
	{
		bool bRtn=false;
		if (nPos+nLen >m_nMemCapacity)
		{
			return bRtn;
		}
		ULONGLONG nOldBufferLen = GetBufferLen();

		if (nPos > nOldBufferLen)
			nPos = nOldBufferLen;

		if (nLen > nOldBufferLen)
			nLen = nOldBufferLen;

		if (nPos+nLen > nOldBufferLen)
		{
			nLen =  nOldBufferLen-nPos;
		}

		//int nOldptr = *(int*)&m_pWritePtr;
		CopyMemory(pOut, getbuffer(0)+nPos+HBUF_HDR_SIZE+HBUF_IPADDR_LEN+HBUF_TYPEID_SIZE, nLen);

		// Slide the buffer back - like sinking the data
		MoveMemory( getbuffer(0)+nPos+HBUF_HDR_SIZE+HBUF_IPADDR_LEN+HBUF_TYPEID_SIZE, 
					getbuffer(0)+nPos+HBUF_HDR_SIZE+HBUF_IPADDR_LEN+HBUF_TYPEID_SIZE+nLen, 
					nOldBufferLen - (nPos+HBUF_HDR_SIZE+HBUF_IPADDR_LEN+HBUF_TYPEID_SIZE+nLen) );

		UpdateBufferLen(nOldBufferLen-nLen);
 		DeAllocateBuffer(GetBufferLen());

		return bRtn;
	}//bool CHeaderBuffer::Cut(PBYTE pOut, ULONGLONG nLen, ULONGLONG nPos)

	void    CHeaderBuffer::GetBufType(OUT BYTE& chType)
	{
		//ͱHBUF_HDR_SIZE+HBUF_IPADDR_LENƫƴ
		CopyMemory(&chType,m_pBase+HBUF_HDR_SIZE+HBUF_IPADDR_LEN,sizeof(char));
	}//void    CHeaderBuffer::GetBufType(OUT char& chType)

	void    CHeaderBuffer::SetBufType(IN  const BYTE  chType)
	{
		//дָλ
		CopyMemory(m_pBase+HBUF_HDR_SIZE+HBUF_IPADDR_LEN,&chType,HBUF_TYPEID_SIZE);
	}//void CHeaderBuffer::SetBufType(char pIn )

 

	void    CHeaderBuffer::GetIpAddr(OUT BYTE* pOutBuf, IN const int nOutBufLen)
	{
		if (!pOutBuf || nOutBufLen<16)
		{
			return;
		}
        memset(pOutBuf,0,nOutBufLen);

		int nLen = (nOutBufLen<HBUF_IPADDR_LEN-1)?nOutBufLen:HBUF_IPADDR_LEN-1;

		//ip־HBUF_HDR_SIZEƫƴ
		CopyMemory(pOutBuf, m_pBase+HBUF_HDR_SIZE, nLen);
		//nOutBufLen<HBUF_IPADDR_LEN,ڴԽ pOutBuf[HBUF_IPADDR_LEN-1] = '\0';
	}//

	void    CHeaderBuffer::SetIpAddr(IN const BYTE* pInBuf)
	{
		if (!pInBuf)
		{
			return;
		}
		int nInBufLen = strlen((char*)pInBuf);
		int nLen = (nInBufLen<HBUF_IPADDR_LEN)?nInBufLen:HBUF_IPADDR_LEN;

		char chs[HBUF_IPADDR_LEN];
		memset(chs, 0, HBUF_IPADDR_LEN);
		CopyMemory(m_pBase+HBUF_HDR_SIZE, chs,  HBUF_IPADDR_LEN);

		//ip־HBUF_HDR_SIZEƫƴ
		CopyMemory(m_pBase+HBUF_HDR_SIZE, pInBuf,  nLen);
	}//

	bool	CHeaderBuffer::IsMemValid()
	{
		BYTE pOutBuf[HBUF_IPADDR_LEN];
		memset(pOutBuf,0,HBUF_IPADDR_LEN);

		GetIpAddr(OUT pOutBuf, IN HBUF_IPADDR_LEN);
		if ((pOutBuf[HBUF_IPADDR_LEN-1]=='\0' && strlen((char*)pOutBuf)==0) 
		  ||(nsYLX::CNet::MemFormatValid(pOutBuf))
			)
		{
			return true;
		}

		return false;
	}

	ULONGLONG CHeaderBuffer::write(PBYTE pData, ULONGLONG nSize, ULONGLONG nPos)
	{
		if (!pData)
		{
			return 0;
		}

 
		int nOldBufferLen = GetBufferLen();
		ReAllocateBuffer(nSize + nPos + (ULONGLONG)( m_pWritePtr-m_pBase) );

		//if (nPos != HBUF_HDR_SIZE+HBUF_TYPEID_SIZE)
		{
			//seek(m_pWritePtr, (m_pWritePtr-m_pBase)+nPos);
		}

		nsHelper::CNsLock singleLock(&m_Criti);
		singleLock.Lock();

		//+ռõ4ֽ=nSize+HBUF_HDR_SIZE дָλ
		ULONGLONG nTmp = nSize+HBUF_HDR_SIZE;
		memset(m_pWritePtr,0,HBUF_HDR_SIZE);
		MoveMemory(m_pWritePtr,&nTmp,sizeof(nTmp));

		//дָλ
		//char nType = 0xff;
		//SetBufType(nType);

		//д뵽ָλ
		MoveMemory/*CopyMemory*/(m_pWritePtr+HBUF_HDR_SIZE,pData,nSize);

		if (nPos <= HBUF_HDR_SIZE+HBUF_IPADDR_LEN+HBUF_TYPEID_SIZE)
		{
			//ĬϲӦ˳д,֮дָHBUF_HDR_SIZEƫƣΪÿдһݣҪдݳȵָλá
			seek(m_pWritePtr, (m_pWritePtr-m_pBase)+nSize+HBUF_HDR_SIZE);
		}else
		{
			//д
		    seek(m_pWritePtr, nSize+nPos+HBUF_IPADDR_LEN+HBUF_TYPEID_SIZE );
		}
		singleLock.Unlock();

		//ܳȸµBUFָλãBUFͷܳȰ+HBUF_HDR_SIZE+HBUF_IPADDR_LEN+HBUF_TYPEID_SIZE ݳ
		UpdateBufferLen(nOldBufferLen + nSize+HBUF_HDR_SIZE);



		return nSize;
	}//ULONGLONG CHeaderBuffer::write(PBYTE pData, ULONGLONG nSize, ULONGLONG nPos)


	//you can call Seek() before it
	ULONGLONG CHeaderBuffer::Write(PBYTE pData, ULONGLONG nSize, ULONGLONG nPos)
	{
		return write(  pData,   nSize,   nPos+HBUF_HDR_SIZE);
	}//ULONGLONG CHeaderBuffer::Write(PBYTE pData, ULONGLONG nSize)

	ULONGLONG CHeaderBuffer::read(PBYTE pOut, ULONGLONG nSize, ULONGLONG nPos)
	{
		nsHelper::CNsLock singleLock(&m_Criti);
		singleLock.Lock();

		ULONGLONG nOldBufferLen = GetBufferLen();

		if (nSize >nOldBufferLen)
		{
			singleLock.Unlock();
			return 0;
		}
 

		MoveMemory/*CopyMemory*/(pOut, m_pBase+nPos,nSize);
 
		seek(m_pReadPtr, nPos+nSize);

		singleLock.Unlock();

		return nSize;
	}//bool read(PBYTE pOut, ULONGLONG nSize, ULONGLONG nPos)

	ULONGLONG CHeaderBuffer::Read(PBYTE pOut, ULONGLONG nSize, ULONGLONG nPos) 
	{
		if (nSize<=0)
		{
			return 0;
		}

 
        return read( pOut,  nSize,  nPos+HBUF_HDR_SIZE+HBUF_IPADDR_LEN+HBUF_TYPEID_SIZE);
        //return read( pOut,  nSize,  nPos);
	}//ULONGLONG CHeaderBuffer::Read(PBYTE pData, ULONGLONG nSize);

}
