
#ifndef D2E6D211_979A_4e68_B759_1C8B42C51E61
#define D2E6D211_979A_4e68_B759_1C8B42C51E61

 
#include <windows.h>
#include <assert.h>

/*
  Name: ͷΪսĹϣѭ
  Copyright: 
  Author: RedSun
  Date: 11-03-07 14:40
  Description: 
  ôԴ2007/11/03 14:40дĳ
  һĩʱ䣬ΪдôһδںܶĴ롣H:\SuccessSourceCode_ylx\program\HashLoopList.cpp
  ЩǷ£Ͳǧ㼯ɽ
 
  ޸ģ2012/10/18 22:02
  Ҫ ļСҪ̵£ȡMFCеCMapʵֹϣѭ޸ԭ룬ʹֶ֧̰֮߳ȫ

*/
#ifndef IN
#define IN 
#endif

#ifndef OUT
#define OUT 
#endif

#ifdef _DEBUG
#define new new(_NORMAL_BLOCK, __FILE__, __LINE__)
#endif

template<class T>
class CHashUnit
{
public:
	UINT Id;
	T   m_val;

	class CHashUnit* Next;
	CHashUnit()
	{
		Id =0;
		Next =0;
	}

	CHashUnit& operator=(CHashUnit& other)
	{
		if (this != &other)
		{
			Id		= other.Id;
			m_val	= other.m_val;
			Next	= other.Next;
		}
		return *this;
	}
};


template<class T>
class __declspec(dllexport) COhsHashList
{
private:
 	CRITICAL_SECTION	m_Criti;
	bool m_bExitApp;
	HANDLE				m_hExitSemaphore;

public:
	UINT m_nTableSize;
	CHashUnit<T> **m_pHashList;


	COhsHashList<T>(UINT nSize=100)
	{
//#ifdef DEBUG
//		_CrtSetDbgFlag(_CrtSetDbgFlag(_CRTDBG_REPORT_FLAG) | _CRTDBG_LEAK_CHECK_DF);
//#endif
		if (nSize>1e6)
		{
			nSize = 1e6;
		}
		m_nTableSize = nSize;
		m_bExitApp = false;

		m_hExitSemaphore = CreateSemaphore( 
			NULL,   // default security attributes
			1,   // initial count
			1,   // maximum count
			NULL//_T("{77305A2D-1E3B-469e-A7E4-1B1A894614B0}")
			);  // unnamed semaphore

		InitializeCriticalSection(&m_Criti);
		InitialHash();
	}

	~COhsHashList(void)
	{
		m_bExitApp=true;
		WaitForSingleObject(m_hExitSemaphore, INFINITE);
		ReleaseSemaphore( 
						 m_hExitSemaphore,  // handle to semaphore
						 1,           // increase count by one
						 NULL);
		FreeHash();
		DeleteCriticalSection(&m_Criti);
		if (m_hExitSemaphore)
		{
			::CloseHandle(m_hExitSemaphore);
			m_hExitSemaphore=0;
		}
	}

	void InitialHash( void )
	{
		int i =0;
		m_pHashList = new CHashUnit<T> *[m_nTableSize];
		for( i =0; i< m_nTableSize; ++i )
		{
			m_pHashList[i] = new CHashUnit<T> ();
			m_pHashList[i]->Id   = 0 ;
			m_pHashList[i]->Next = m_pHashList[i] ;
		}
		return;     
	}

	void FreeHash( void )
	{
		WaitForSingleObject(m_hExitSemaphore, INFINITE);
		int i =0;
		CHashUnit<T> * p=0;

		for( i =0; i< m_nTableSize; ++i )
		{
			for( p=m_pHashList[i]->Next; p!=NULL && p!= m_pHashList[i]; p = p -> Next )
			{
				m_pHashList[i]->Next = p ->Next;
				delete p;

				p=m_pHashList[i]->Next;     
			}
			m_pHashList[i]->Id   = 0;
			m_pHashList[i]->Next = NULL;
			assert(p!=0);
			delete p;p=0;
		}
		delete[] m_pHashList;
		ReleaseSemaphore( 
			m_hExitSemaphore,  // handle to semaphore
			1,           // increase count by one
			NULL);
		return;     
	}


	bool FindInHash( OUT CHashUnit<T> *& Key,IN UINT nId )
	{
		if (m_bExitApp)
		{
			return false;
		}
		WaitForSingleObject(m_hExitSemaphore, INFINITE);
		assert(Key==0);

		CHashUnit<T> * PpHead = m_pHashList[HASHKEY( nId )];
		for(CHashUnit<T> * p=(PpHead)->Next; p!=NULL && p!=(PpHead); p=p->Next )
		{
			if( p-> Id == nId )
			{
				(Key) = p;
				ReleaseSemaphore( 
					m_hExitSemaphore,  // handle to semaphore
					1,           // increase count by one
					NULL);
				return true;     
			}
		}

		ReleaseSemaphore( 
			m_hExitSemaphore,  // handle to semaphore
			1,           // increase count by one
			NULL);
		return false;
	}

	bool InsertNewNode(IN OUT CHashUnit<T> *& NewNode , IN UINT Id  )
	{
		if (m_bExitApp)
		{
			return false;
		}
		WaitForSingleObject(m_hExitSemaphore, INFINITE);
		UINT loc = HASHKEY( Id );
		CHashUnit<T> * pHead=m_pHashList[ loc ],*p=0;

		NewNode = new CHashUnit<T>();
		if(!NewNode)
		{
			ReleaseSemaphore( 
				m_hExitSemaphore,  // handle to semaphore
				1,           // increase count by one
				NULL);
			return false;     
		}
		NewNode->Id = Id;
 
		for( p = pHead->Next; p && p!= pHead; p = p -> Next )
		{
			//ҵͬId,
			if( p-> Id == NewNode -> Id )
			{
				delete NewNode;
				NewNode = p;
				ReleaseSemaphore( 
					m_hExitSemaphore,  // handle to semaphore
					1,           // increase count by one
					NULL);
				return true;    
			}
		}

		//ֱӼӵӱͷ
		assert ( p == pHead ); 

		//EnterCriticalSection(&m_Criti);

			NewNode -> Next = pHead-> Next;
			pHead -> Next   = NewNode; 

		//LeaveCriticalSection(&m_Criti); 
		ReleaseSemaphore( 
			m_hExitSemaphore,  // handle to semaphore
			1,           // increase count by one
			NULL);
		return true;      
		
	}//InsertNewNode

	inline UINT HASHKEY(UINT k)
	{
		return (k%m_nTableSize); 
	}
	
};


#endif


