#pragma once

#include <windows.h>

namespace nsHelper
{
	enum NSLOCKTYPE
	{
		CRITICALSECTION,
		EVENT,
		SEMAPHORE,
		MUTEX
	};
	class  __declspec(dllexport) CNsLock
	{
	public:
		CNsLock( CRITICAL_SECTION*, NSLOCKTYPE eLockType=CRITICALSECTION);
		CNsLock( HANDLE*,			NSLOCKTYPE eLockType=EVENT);
	public:
		~CNsLock(void);
		bool IsLocked(){return m_bLocked;};

		bool Lock(int dwTimeOut = INFINITE);

		bool Unlock();

		//bool Unlock(
		//	long lCount,
		//	long* lPrevCount = 0 
		//	);

	private:
		bool m_bLocked;
		CRITICAL_SECTION* m_pSyncObject;
		HANDLE* m_pCriticalEvent;
		NSLOCKTYPE m_eLockType;
		
	};

}