#include "NsLock.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


namespace nsHelper
{
	//InitializeCriticalSection(&m_SyncObject);
	//DeleteCriticalSection(&m_SyncObject);
	//m_CriticalEvent = CreateEvent( NULL, TRUE, TRUE, NULL );
	//HANDLE hMutexOneInstantance=CreateMutex(NULL,TRUE,_T("PreventSecondInstance"));
	CNsLock::CNsLock(  CRITICAL_SECTION* pSyncObject , NSLOCKTYPE eLockType)
	{
		m_pSyncObject = pSyncObject;

		m_bLocked	  = false;
		m_eLockType   = eLockType;

	}

	CNsLock::CNsLock(HANDLE* pSyncObject , NSLOCKTYPE eLockType)
	{
		m_pCriticalEvent = pSyncObject; 
		m_bLocked		 = false;
		m_eLockType		 = eLockType;
	}

	CNsLock::~CNsLock(void)
	{
	}

	bool CNsLock::Lock(int dwTimeOut)
	{
		bool bRtn =false;

		switch (m_eLockType)
		{
		default:
		case CRITICALSECTION:
			EnterCriticalSection(m_pSyncObject);
			break;
		case EVENT:
		case SEMAPHORE:
		case MUTEX:
			WaitForSingleObject(m_pCriticalEvent,dwTimeOut);
			break;
		}

		m_bLocked = true;
		return bRtn;
	}

	bool CNsLock::Unlock()
	{
		bool bRtn =false;

		switch (m_eLockType)
		{
		default:
		case CRITICALSECTION:
			LeaveCriticalSection(m_pSyncObject); 
			break;
		case EVENT:
			SetEvent(m_pCriticalEvent);
			break;
		case SEMAPHORE:
			ReleaseSemaphore( 
				m_pCriticalEvent,  // handle to semaphore
				1,           // increase count by one
				NULL);
			break;
		case MUTEX:
			ReleaseMutex(m_pCriticalEvent);
			break;
		}

		m_bLocked = false; 

		return bRtn;
	}
}