#include "Net.h"
#include "util.h"

namespace nsYLX
{
	CNet::CNet(void)
	{
	}

	CNet::~CNet(void)
	{
	}

	bool CNet::InitSocketEnv()
	{
		WSADATA wsaData;
		if (WSAStartup(MAKEWORD(2,2), &wsaData) != 0) 
		{ 
			return false;
		} 
		return true;
	}//

	void CNet::ClearSocketEnv()
	{
		WSACleanup();
	}//

	bool CNet::MemFormatValid(IN const BYTE* pMem)
	{
		bool bRtn=false;

		do 
		{
			if (!pMem)
			{
				break;
			}

			if (inet_addr((char*)pMem)==INADDR_NONE)
			{
				break;
			}
			bRtn=true;
		} while (0);

 
		return bRtn;
	}//

	bool CNet::GetLocalIpAddr(OUT BYTE* pOutBuf,IN int nOutBufLen)
	{	
		if (!pOutBuf || nOutBufLen<16 )
		{
			return false;
		}


		bool bRtn = false;

		do 
		{
			BYTE host_name[255];
			//ȡ
			if (gethostname((char*)host_name, sizeof(host_name)) == SOCKET_ERROR) 
			{
				//MessageBox(_T("ȡʧ"));
				break;
			}

			struct hostent *phe = gethostbyname((char*)host_name);
			if (phe == 0)
			{
				//MessageBox(_T("ȡʧ"));
				break;
			}

			//ѭóػIPַ
			int nLen=0;
			for (int i = 0; phe->h_addr_list[i] != 0; ++i) 
			{
				struct in_addr addr;
				memcpy(&addr, phe->h_addr_list[i], sizeof(struct in_addr));

				memset(pOutBuf,0,nOutBufLen);
				char* p = inet_ntoa(addr);
				nLen    = strlen(p);
				memcpy(pOutBuf,p, (nLen<nOutBufLen)?nLen:nOutBufLen);
			}
			bRtn = true;
		} while (0);

		return bRtn;
	}//

	CString CNet::GetHostName(SOCKET socket)
	{
		sockaddr_in  sockAddr;
		memset(&sockAddr, 0, sizeof(sockAddr));

		int nSockAddrLen = sizeof(sockAddr);

		BOOL bResult = getpeername(socket,(SOCKADDR*)&sockAddr, &nSockAddrLen);

		CString s(_T(""));
		if (bResult != INVALID_SOCKET)
		{
			WCHAR* pWideChars =  new WCHAR[MAX_PATH];
			nsYLX::CUtil::MToWBytes
			(
			IN	 (BYTE*)inet_ntoa(sockAddr.sin_addr),
			OUT  pWideChars,
			IN   MAX_PATH*2
			);
				
			s.Format(_T("%s"),pWideChars);
			delete[] pWideChars;
		}
		return s; 
	}//CString CNet::GetHostName(SOCKET socket)

}