
#include "Util.h"

#define STRICT
#include <windows.h>
#include <stdio.h>
#include <ctype.h>
#include <locale.h>

//http://www.rarlab.com/rar_add.htm
#include "unrar.h"
#include <tchar.h>

#include "FileOp.h"
 


void ExtractArchiveA(char *srcFn, char* desPath)
{
	if (!srcFn || strlen(srcFn) == 0)
	{
		return;
	}

	HANDLE hArcData;
	int RHCode,PFCode;
	char *CmtBuf=new char[16384];
	struct RARHeaderDataEx HeaderData;
	struct RAROpenArchiveDataEx OpenArchiveData;

	memset(&OpenArchiveData,0,sizeof(OpenArchiveData));
	OpenArchiveData.ArcName=srcFn;
	OpenArchiveData.CmtBuf=CmtBuf;
	OpenArchiveData.CmtBufSize=sizeof(CmtBuf);
	OpenArchiveData.OpenMode=RAR_OM_EXTRACT;
	OpenArchiveData.Callback=NULL;//CallbackProc;
	OpenArchiveData.UserData=0;
	hArcData=RAROpenArchiveEx(&OpenArchiveData);

	do 
	{
		if (OpenArchiveData.OpenResult!=0)
		{

			break;
		}

		HeaderData.CmtBuf=NULL;
		memset(&OpenArchiveData.Reserved,0,sizeof(OpenArchiveData.Reserved));

		while ((RHCode=RARReadHeaderEx(hArcData,&HeaderData))==0)
		{
			PFCode=RARProcessFile(hArcData, RAR_EXTRACT , desPath, NULL);
			if (PFCode==0)
			{
				;//printf(" OK");
			}
			else
			{
				break;
			}
		}

	} while (0);

	RARCloseArchive(hArcData);
	delete[] CmtBuf;

}//void ExtractArchive(char *srcFn, char* desPath)

 
void ExtractArchiveW(WCHAR *srcFn, WCHAR* desPath)
{
	if (!srcFn || wcslen(srcFn) == 0)
	{
		return;
	}
 

	HANDLE hArcData;
	int RHCode,PFCode;
	char *CmtBuf=new char[16384];
	struct RARHeaderDataEx HeaderData;
	struct RAROpenArchiveDataEx OpenArchiveData;

	memset(&OpenArchiveData,0,sizeof(OpenArchiveData));
	OpenArchiveData.ArcNameW=srcFn;
	OpenArchiveData.CmtBuf=CmtBuf;
	OpenArchiveData.CmtBufSize=sizeof(CmtBuf);
	OpenArchiveData.OpenMode=RAR_OM_EXTRACT;
	OpenArchiveData.Callback=NULL;//CallbackProc;
	OpenArchiveData.UserData=0;
	hArcData=RAROpenArchiveEx(&OpenArchiveData);

	do 
	{
		if (OpenArchiveData.OpenResult!=0)
		{

			break;
		}
		HeaderData.CmtBuf=NULL;
		memset(&OpenArchiveData.Reserved,0,sizeof(OpenArchiveData.Reserved));

		while ((RHCode=RARReadHeaderEx(hArcData,&HeaderData))==0)
		{
			PFCode=RARProcessFileW(hArcData, RAR_EXTRACT , desPath, NULL);
			if (PFCode==0)
			{
				;//printf(" OK");
			}
			else
			{
				break;
			}
		} 
	} while (0);

	RARCloseArchive(hArcData);
	delete[] CmtBuf;

}//void ExtractArchiveW(char *srcFn, char* desPath)

namespace nsYLX
{

	CFileOp::CFileOp(void)
	{
		m_tchRarFullName = new TCHAR[MAX_PATH];

		TCHAR tchRarSetupPath[MAX_PATH];
		int nTmp = MAX_PATH*sizeof(TCHAR);
		ZeroMemory(tchRarSetupPath,nTmp);


		HKEY hKey;
		//HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\WinRAR.exe  path
		if(RegOpenKey(HKEY_CURRENT_USER, _T("Software\\WinRAR SFX"), &hKey) ==ERROR_SUCCESS)
		{
			DWORD dwtype=0;

			LONG lRtn=RegQueryValueEx(
				hKey,				// handle of key to query 
				_T("C%%Program Files%WinRAR"),		//LPTSTR lpValueName,	// address of name of value to query 
				0,						//LPDWORD lpReserved,	// reserved 
				&dwtype,				//LPDWORD lpType,	// address of buffer for value type 
				(LPBYTE)&tchRarSetupPath,	//LPBYTE lpData,	// address of data buffer 
				(LPDWORD) &nTmp		//LPDWORD lpcbData 	// address of data buffer size 
				);

			RegCloseKey(hKey);
		}else
		{

			//::MessageBox(NULL,_T("밲װWinRar,޷λwinRarװĿ¼@CFileOp::CFileOp"),_T("Error:"),0);
		}

		nTmp = MAX_PATH*sizeof(TCHAR);
		ZeroMemory(m_tchRarFullName,nTmp);

		CUtil::GenericAbsFullPath(IN tchRarSetupPath,IN _T("RAR.exe"),OUT m_tchRarFullName, IN nTmp);
	}//

	CFileOp::~CFileOp(void)
	{
		delete[] m_tchRarFullName;m_tchRarFullName=0;
	}
	
	void  CFileOp::ClearVector(std::vector<TCHAR*>* vt)
	{
		for (int i=0;i<(*vt).size();i++)
		{
			TCHAR* p = (*vt)[i];
			if (p)
			{
				delete[] p;
				(*vt)[i]=0;
			}
		}
		(*vt).clear();
		(*vt).~vector();	
	}

	BOOL CFileOp::SafeBitCopySingleFile(TCHAR* ptchSrcFileName, TCHAR *ptchsDesFileName)
	{
		BOOL bRtn=FALSE;

		if (!ptchSrcFileName || _tcslen(ptchSrcFileName) ==0)
		{
			return bRtn;
		}

		if (!ptchsDesFileName || _tcslen(ptchsDesFileName) ==0)
		{
			return bRtn;
		}

		LARGE_INTEGER lpFileSize={0,0};
		if (!CUtil::GetFileSize(IN ptchSrcFileName, OUT &lpFileSize))
		{
			return bRtn;
		}

		//νļȫȴĿնļ(ڵĻ)ȻѭԴļдĿļɡ򵥰ɣ¸¡
		CUtil::GenericEmptyFile(ptchsDesFileName, lpFileSize.QuadPart);
 

		//ڿѭдˡ
		ULONGLONG ullReadPos=0L,ullWritePos = 0L;
		int nTransSize=1000;
		BYTE *pTransBuf = new BYTE[nTransSize];

		HANDLE hSrcFile = INVALID_HANDLE_VALUE, hDesFile =INVALID_HANDLE_VALUE;
		do 
		{
			hSrcFile = CreateFile(
				ptchSrcFileName,    // file to open
				GENERIC_READ,          // open for reading
				0,//FILE_SHARE_READ,       // share for reading
				NULL,                  // default security
				OPEN_EXISTING,         // existing file only
				FILE_ATTRIBUTE_NORMAL, // normal file
				NULL);                 // no attr. template

			if (hSrcFile == INVALID_HANDLE_VALUE) 
			{ 
				//AfxMessageBox(_T("Could not open file (error )@TransFilesClientDlg.cpp DataArrivedCallBack\n"));
				break;
			}

			hDesFile = CreateFile(
				ptchsDesFileName,    // file to open
				GENERIC_WRITE,          // open for reading
				FILE_SHARE_WRITE,       // share for reading
				NULL,                  // default security
				OPEN_EXISTING,         // existing file only
				FILE_ATTRIBUTE_NORMAL, // normal file
				NULL);                 // no attr. template

			if (hDesFile == INVALID_HANDLE_VALUE) 
			{ 
				break;
			}
				
			DWORD dwReadRtn=0, dwWriteRtn=0;
			do 
			{
				if (!SetFilePointerEx(hSrcFile,  *(LARGE_INTEGER*)&ullReadPos, NULL, FILE_BEGIN))
				{
					break;
				}
 
				if (!ReadFile(hSrcFile, pTransBuf, nTransSize, &dwReadRtn, NULL) || dwReadRtn == 0)
				{
					//TCHAR tchs[MAX_PATH];
					//nsYLX::CUtil::GetErrorMessage(tchs,MAX_PATH);
					//TCHAR tcsMsg[MAX_PATH];
					//_stprintf(tcsMsg,_T("ReadFile err: %s\n@TransFilesClientDlg.cpp"),tchs);
					//AfxMessageBox(tcsMsg);
					break;
				}
 
				ullReadPos  += dwReadRtn;

				//ƶдָ
				if (!SetFilePointerEx(hDesFile,  *(LARGE_INTEGER*)&ullWritePos , NULL, FILE_BEGIN))
				{
					break;
				}

				if (!::WriteFile(hDesFile, pTransBuf, dwReadRtn, &dwWriteRtn,NULL)
					|| (dwWriteRtn !=  dwReadRtn)
					)
				{
					break;
				}
				ullWritePos  += dwWriteRtn;

			} while (ullReadPos<lpFileSize.QuadPart);

		} while (0);

		bRtn = (ullWritePos == lpFileSize.QuadPart);

		if (hSrcFile != INVALID_HANDLE_VALUE) 
		{ 
			CloseHandle(hSrcFile);
			hSrcFile = INVALID_HANDLE_VALUE;
		}

		if (hDesFile != INVALID_HANDLE_VALUE) 
		{ 
			CloseHandle(hDesFile);
			hDesFile = INVALID_HANDLE_VALUE;
		}
 
		delete[] pTransBuf;
				
		return bRtn;

	}//BOOL CFileOp::SafeBitCopySingleFile

	//Ŀ¼ptchSrcPathļԼļпĿ·ptchsDesPath
	BOOL CFileOp::SafeBitCopyPath(TCHAR* ptchSrcPath, TCHAR *ptchsDesPath,std::vector<TCHAR*>* vtCopyFaildFiles)
	{
		BOOL bRtn=FALSE;
		if (!ptchSrcPath || _tcslen(ptchSrcPath) ==0)
		{
			return bRtn;
		}

		if (!ptchsDesPath || _tcslen(ptchsDesPath) ==0)
		{
			return bRtn;
		}

		CUtil::AddTailBackslash(ptchSrcPath);
		CUtil::AddTailBackslash(ptchsDesPath);

		//Ŀ·ڣ½
		if (!nsYLX::CUtil::IsFileExists(ptchsDesPath))
		{
			if ( !CreateDirectory(ptchsDesPath,NULL) )
			{
#ifdef DEBUG
				TCHAR tchsTmp[MAX_PATH];
				nsYLX::CUtil::GetErrorMessage(IN tchsTmp,IN  MAX_PATH);
				_tcscat(tchsTmp,_T(" CFileOp::SafeBitCopyPath"));
				::MessageBox(0,tchsTmp,_T("error:"),0);
#endif
				return bRtn;
			}
		}

		TCHAR *ptchsWildCard = new TCHAR[MAX_PATH];
		ZeroMemory(ptchsWildCard, MAX_PATH*sizeof(TCHAR));
		_tcscpy(ptchsWildCard,ptchSrcPath);
		_tcscat(ptchsWildCard,_T("*"));

		HANDLE hFind;
		BOOL   bMoreFiles=TRUE;

		WIN32_FIND_DATA dataFind;
		ZeroMemory(&dataFind,sizeof(WIN32_FIND_DATA));
		TCHAR *ptchsFileName= new TCHAR[MAX_PATH];
		TCHAR *ptchsSrcFullFileName= new TCHAR[MAX_PATH];
		TCHAR *ptchsDesFullFileName= new TCHAR[MAX_PATH];

 
		hFind=FindFirstFile( ptchsWildCard,&dataFind);//ҵ·ļ

		do 
		{
			ZeroMemory(ptchsFileName,sizeof(TCHAR)*MAX_PATH);
			_tcscpy(ptchsFileName, dataFind.cFileName);


			if(!(dataFind.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY))//жǷļ 
			{ 
				//ļ
				ZeroMemory(ptchsSrcFullFileName,sizeof(TCHAR)*MAX_PATH);
				_tcscpy(ptchsSrcFullFileName, ptchSrcPath);
				_tcscat(ptchsSrcFullFileName, dataFind.cFileName);

				ZeroMemory(ptchsDesFullFileName,sizeof(TCHAR)*MAX_PATH);
				_tcscpy(ptchsDesFullFileName, ptchsDesPath);
				_tcscat(ptchsDesFullFileName, dataFind.cFileName);

				if (!CFileOp::SafeBitCopySingleFile( ptchsSrcFullFileName, ptchsDesFullFileName))
				{
					TCHAR* ptchTmp = new TCHAR[MAX_PATH];
					ZeroMemory(ptchTmp,MAX_PATH*sizeof(TCHAR));
					_tcscpy(ptchTmp,ptchsDesFullFileName);
					
					vtCopyFaildFiles->push_back(ptchTmp);

					break;
				} 
			}
			else if (_tcscmp(ptchsFileName, _T(".")) != 0 &&  _tcscmp(ptchsFileName, _T("..")) != 0)
			{ 
				//Ŀ¼,ݹ
				ZeroMemory(ptchsSrcFullFileName,sizeof(TCHAR)*MAX_PATH);
				_tcscpy(ptchsSrcFullFileName, ptchSrcPath);
				_tcscat(ptchsSrcFullFileName, dataFind.cFileName);

				ZeroMemory(ptchsDesFullFileName,sizeof(TCHAR)*MAX_PATH);
				_tcscpy(ptchsDesFullFileName, ptchsDesPath);
				_tcscat(ptchsDesFullFileName, dataFind.cFileName);

				if (!CFileOp::SafeBitCopyPath( ptchsSrcFullFileName, ptchsDesFullFileName,vtCopyFaildFiles))
				{
					break;
				} 

			}
			bMoreFiles=FindNextFile(hFind,&dataFind); 
		} while (bMoreFiles); 
		FindClose(hFind);

		bRtn  = !bMoreFiles;
 
		delete[] ptchsWildCard;
		delete[] ptchsFileName; 
		delete[] ptchsSrcFullFileName;
		delete[] ptchsDesFullFileName;

		return bRtn;
	}//

	int CFileOp::GetParentPath(IN const TCHAR* ptchsPath, OUT TCHAR* pOutPath, IN int nOutPathLen, IN int nLevel)
	{
		int nRtn =0;
		if (!ptchsPath)
		{
			return nRtn;
		}

		int nLen = _tcslen(ptchsPath);
		if (0==nLen || !pOutPath || nOutPathLen<=0 || nLevel<=0)
		{
			return 0;
		}
 
		TCHAR *pTchsTmp = new TCHAR[nLen+1];
		ZeroMemory(pTchsTmp, (nLen+1)*sizeof(TCHAR));
		_tcscpy(pTchsTmp, ptchsPath);

		CUtil::ChangeBackSlash(pTchsTmp, nLen);
 
		int nTmp = _tcslen(pTchsTmp);

		pTchsTmp[nTmp-1]=_T('\0');//ĩβ/ȥ

		int nIndex  = nTmp-1;
		for (int i= nTmp-1;i>=0;i--)
		{
			if (pTchsTmp[i] == _T('/'))
			{
				if (--nLevel == 0)
				{
					//pTchsTmp[i] = _T('\0');
					nIndex  = i;
					break;
				}
			}
		}

		ZeroMemory(pOutPath, nOutPathLen*sizeof(TCHAR));
		_tcsncpy(pOutPath,pTchsTmp, nIndex+1);


		nRtn = nIndex+1;

		delete[] pTchsTmp;

		return nRtn;
	}//

	void CFileOp::AddToRar(IN TCHAR* tchsSrc, IN TCHAR* tchsDes)
	{
		BOOL bRtn =FALSE;
		TCHAR tchsWinRarCommandLine[MAX_PATH];
		/*
		rar a -r -ep1 E:\SourceCodeStudy\MFC_Source\ftp\WinsockI
		OCP_demoV2.0\ansidebug\2972FCDC-B8B7-4153-AE83-ED6DA0CDC87E\x2.rar  E:\SourceCod
		eStudy\MFC_Source\ftp\WinsockIOCP_demoV2.0\ansidebug\2972FCDC-B8B7-4153-AE83-ED6
		DA0CDC87E\tmp\*.*		
		*/
		_stprintf(tchsWinRarCommandLine,_T(" a -r -ep1  \"%s\" \"%s/*.*\" "),tchsDes, tchsSrc);


		SHELLEXECUTEINFO ShExecInfo = {0};
		ZeroMemory(&ShExecInfo, sizeof(SHELLEXECUTEINFO));

		ShExecInfo.cbSize = sizeof(SHELLEXECUTEINFO);

		ShExecInfo.fMask = SEE_MASK_NO_CONSOLE|SEE_MASK_NOCLOSEPROCESS;//SEE_MASK_NOCLOSEPROCESS;//SEE_MASK_UNICODE|SEE_MASK_CONNECTNETDRV;//
		ShExecInfo.hwnd = NULL;
		ShExecInfo.lpVerb = NULL;
		ShExecInfo.lpFile = m_tchRarFullName;//_T("D:/Program Files/WinRAR/RAR.exe");
		ShExecInfo.lpParameters = tchsWinRarCommandLine;
		ShExecInfo.lpDirectory = NULL;
		ShExecInfo.nShow = SW_HIDE;//|SEE_MASK_DOENVSUBST;
		ShExecInfo.hInstApp = NULL;
		ShellExecuteEx(&ShExecInfo);

		WaitForSingleObject(ShExecInfo.hProcess, INFINITE);
		return  ;
	}//
}