// Buffer.h: interface for the CBuffer class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BUFFER_H__829F6693_AC4D_11D2_8C37_00600877E420__INCLUDED_)
#define AFX_BUFFER_H__829F6693_AC4D_11D2_8C37_00600877E420__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


namespace nsComm
{

	enum EMSGTYPE
	{
		STRING,
		STRUCT,
		FTPREPORT
	};

	#define HDR_SIZE sizeof(int)
	#define TYPEID_SIZE sizeof(char)


	class __declspec(dllexport) CBuffer  
	{
	protected:
		PBYTE	m_pBase;
		PBYTE	m_pPtr;
		UINT	m_nSize;
 
	protected:
		UINT ReAllocateBuffer(UINT nRequestedSize);
		UINT DeAllocateBuffer(UINT nRequestedSize);
		UINT GetMemSize();
 		CRITICAL_SECTION		m_BufferCriti;
	public:
		void ClearBuffer();

		UINT Delete(UINT nSize);
		UINT Read(PBYTE pData, UINT nSize, BOOL bDelAfterRead = TRUE);
		BOOL Write(PBYTE pData, UINT nSize);

		UINT GetBufferLen();
		int  Scan(PBYTE pScan,UINT nPos);
		BOOL Insert(PBYTE pData, UINT nSize);

		void  Copy(CBuffer& buffer);	
		PBYTE GetBuffer(UINT nPos=0);

		CBuffer();
		CBuffer(CBuffer* pOther);
		CBuffer& CBuffer::operator=(const CBuffer& other);

		
		~CBuffer();
 
	};
}



#endif // !defined(AFX_BUFFER_H__829F6693_AC4D_11D2_8C37_00600877E420__INCLUDED_)
