﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Runtime.CompilerServices;
using System.Text;

namespace PlanDemoService
{
    public class Loger
    {
        /// <summary>
        /// 记录日志
        /// </summary>
        /// <param name="o"></param>
        /// <param name="path"></param>
        [MethodImpl(MethodImplOptions.Synchronized)]
        public static void Write(string files, string msg, string folder = "Log\\")
        {
            if (!string.IsNullOrEmpty(msg))
            {
                if (!Directory.Exists(System.IO.Path.Combine(System.AppDomain.CurrentDomain.BaseDirectory, folder)))
                    Directory.CreateDirectory(Path.Combine(AppDomain.CurrentDomain.BaseDirectory, folder));
                using (StreamWriter sw = new StreamWriter(files, true))
                {
                    sw.WriteLine(msg);
                }
            }
            Console.WriteLine(msg);
        }

        #region 记录日志
        public static void Log()
        {
            try
            {
                Loger.Write(System.IO.Path.Combine(System.AppDomain.CurrentDomain.BaseDirectory, "Log\\", "log_" + DateTime.Now.ToString("yyyyMMdd") + ".log"), Environment.NewLine);
            }
            catch { }
        }
        public static void Log(String msg, string fileParam)
        {
            try
            {
                Loger.Write(System.IO.Path.Combine(System.AppDomain.CurrentDomain.BaseDirectory, "Log\\", "log_" + DateTime.Now.ToString("yyyyMMdd") + "_" + fileParam + ".log"), "[" + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss") + "] " + msg);
            }
            catch { }
        }

        public static void Error(String msg)
        {
            try
            {
                Loger.Write(System.IO.Path.Combine(System.AppDomain.CurrentDomain.BaseDirectory, "Log\\", "Error_" + DateTime.Now.ToString("yyyyMMdd") + ".log"), "[" + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss") + "] " + msg);
            }
            catch
            {
            }
        }

        public static void Error(Exception ex, string methodName)
        {
            try
            {
                if (ex != null && ex.Message != null)
                {
                    Loger.Write(
                        System.IO.Path.Combine(System.AppDomain.CurrentDomain.BaseDirectory, "Log\\",
                            "Error_" + DateTime.Now.ToString("yyyyMMdd") + ".log"),
                        "**********************************************************************************");
                    if (!string.IsNullOrEmpty(methodName))
                    {
                        Loger.Write(System.IO.Path.Combine(System.AppDomain.CurrentDomain.BaseDirectory, "Log\\", "Error_" + DateTime.Now.ToString("yyyyMMdd") + ".log"), "[" + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss") + "] 异常所在方法：" + methodName + Environment.NewLine + ex.Message.Trim());
                    }
                    if (!string.IsNullOrEmpty(ex.StackTrace))
                    {
                        Loger.Write(System.IO.Path.Combine(System.AppDomain.CurrentDomain.BaseDirectory, "Log\\", "Error_" + DateTime.Now.ToString("yyyyMMdd") + ".log"), "[" + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss") + "] Error StackTrace：" + ex.StackTrace);
                    }
                    if (!string.IsNullOrEmpty(ex.Source))
                    {
                        Loger.Write(System.IO.Path.Combine(System.AppDomain.CurrentDomain.BaseDirectory, "Log\\", "Error_" + DateTime.Now.ToString("yyyyMMdd") + ".log"), "[" + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss") + "] Error Source：" + ex.Source);
                    }
                    if (ex.TargetSite != null)
                    {
                        Loger.Write(System.IO.Path.Combine(System.AppDomain.CurrentDomain.BaseDirectory, "Log\\", "Error_" + DateTime.Now.ToString("yyyyMMdd") + ".log"), "[" + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss") + "] Error TargetSite：" + ex.TargetSite.Name);
                    }
                    Loger.Write(System.IO.Path.Combine(System.AppDomain.CurrentDomain.BaseDirectory, "Log\\", "Error_" + DateTime.Now.ToString("yyyyMMdd") + ".log"),
                        "**********************************************************************************");
                    if (ex.InnerException != null) Error(ex.InnerException, methodName);

                }
            }
            catch { }
        }

        #endregion
    }
}
