// PJAGridCellDemoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PJAGridCellDemo.h"
#include "PJAGridCellDemoDlg.h"
#include "NewCellTypes\GridCellNumeric.h"
#include "NewCellTypes\GridCellCheck.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPJAGridCellDemoDlg dialog

CPJAGridCellDemoDlg::CPJAGridCellDemoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPJAGridCellDemoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPJAGridCellDemoDlg)
	m_radios = -1;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPJAGridCellDemoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPJAGridCellDemoDlg)
	DDX_Control(pDX, IDC_SILENT, m_Silent);
	DDX_Control(pDX, IDC_NEGATIVE, m_Negative);
	DDX_Radio(pDX, IDC_INTEGER, m_radios);
	//}}AFX_DATA_MAP
    DDX_Control(pDX, IDC_CUSTOM1, m_Grid);
}

BEGIN_MESSAGE_MAP(CPJAGridCellDemoDlg, CDialog)
	//{{AFX_MSG_MAP(CPJAGridCellDemoDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_CURRENCY, OnCurrency)
	ON_BN_CLICKED(IDC_INTEGER, OnInteger)
	ON_BN_CLICKED(IDC_NEGATIVE, OnNegative)
	ON_BN_CLICKED(IDC_REAL, OnReal)
	ON_BN_CLICKED(IDC_SILENT, OnSilent)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPJAGridCellDemoDlg message handlers

BOOL CPJAGridCellDemoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
    m_Grid.SetRowCount(10);
    m_Grid.SetColumnCount(10);
    m_Grid.SetFixedRowCount(1);
    m_Grid.SetFixedColumnCount(1);

    m_Grid.EnableTitleTips();
    m_Grid.SetCellType(1, 1, RUNTIME_CLASS(CGridCellNumeric));
    m_Grid.SetCellType(2, 2, RUNTIME_CLASS(CGridCellCheck));

    CGridCellNumeric *pCell = (CGridCellNumeric *)m_Grid.GetCell(1, 1);
    pCell->SetFlags(CGridCellNumeric::Real | CGridCellNumeric::Negative);
    m_Negative.SetCheck(TRUE);
    ((CButton *)GetDlgItem(IDC_REAL))->SetCheck(TRUE);
    pCell->SetNumber(-123456.789012345);

    int i = 0;
    CString str;
    for (i = 1; i < 10; ++i)
    {
        str.Format(_T("Column %d"), i);
        m_Grid.SetItemText(0, i, str);
    }

    for (i = 1; i < 10; ++i)
    {
        str.Format(_T("Row %d"), i);
        m_Grid.SetItemText(i, 0, str);
    }
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPJAGridCellDemoDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPJAGridCellDemoDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPJAGridCellDemoDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CPJAGridCellDemoDlg::OnCurrency() 
{
	// TODO: Add your control notification handler code here
    m_Grid.Invalidate();
    CGridCellNumeric *pCell = (CGridCellNumeric *)m_Grid.GetCell(1, 1);
	DWORD Flags = pCell->GetFlags();
    double number = pCell->GetNumber();
    Flags &= ~CGridCellNumeric::TypeMask;
    Flags |= CGridCellNumeric::Currency;
    pCell->SetFlags(Flags);
    pCell->SetNumber(number);
}

void CPJAGridCellDemoDlg::OnInteger() 
{
	// TODO: Add your control notification handler code here
    m_Grid.Invalidate();
    CGridCellNumeric *pCell = (CGridCellNumeric *)m_Grid.GetCell(1, 1);
	DWORD Flags = pCell->GetFlags();
    double number = pCell->GetNumber();
    Flags &= ~CGridCellNumeric::TypeMask;
    Flags |= CGridCellNumeric::Integer;
    pCell->SetFlags(Flags);
    pCell->SetNumber(number);
}

void CPJAGridCellDemoDlg::OnNegative() 
{
	// TODO: Add your control notification handler code here
    m_Grid.Invalidate();
    CGridCellNumeric *pCell = (CGridCellNumeric *)m_Grid.GetCell(1, 1);
	DWORD Flags = pCell->GetFlags();
    double number = pCell->GetNumber();
    if (m_Negative.GetCheck())
        Flags |= CGridCellNumeric::Negative;
    else
    {
        Flags &= ~CGridCellNumeric::Negative;
        if (number < 0.0)
            number *= -1.0;
    }
    pCell->SetFlags(Flags);
    pCell->SetNumber(number);
}

void CPJAGridCellDemoDlg::OnReal() 
{
	// TODO: Add your control notification handler code here
    m_Grid.Invalidate();
    CGridCellNumeric *pCell = (CGridCellNumeric *)m_Grid.GetCell(1, 1);
	DWORD Flags = pCell->GetFlags();
    double number = pCell->GetNumber();
    Flags &= ~CGridCellNumeric::TypeMask;
    Flags |= CGridCellNumeric::Real;
    pCell->SetFlags(Flags);
    pCell->SetNumber(number);
}

void CPJAGridCellDemoDlg::OnSilent() 
{
	// TODO: Add your control notification handler code here
    CGridCellNumeric *pCell = (CGridCellNumeric *)m_Grid.GetCell(1, 1);
	DWORD Flags = pCell->GetFlags();
    if (m_Silent.GetCheck())
        Flags |= CGridCellNumeric::Silent;
    else
        Flags &= ~CGridCellNumeric::Silent;
    pCell->SetFlags(Flags);
}
