/***************************************************************************
ImageViewer.h : header file for the Image Viewer tool
written by PJ Arends
pja@telus.net

The ShowImageList portion was written by Jrgen Sigvardson <jorgen@profitab.com>

For updates check http://www3.telus.net/pja/ImageViewer.htm

-----------------------------------------------------------------------------
This code is provided as is, with no warranty as to it's suitability or usefulness
in any application in which it may be used. This code has not been tested for
UNICODE builds, nor has it been tested on a network ( with UNC paths ).

This code may be used in any way you desire. This file may be redistributed by any
means as long as it is not sold for profit, and providing that this notice and the
authors name are included.

If any bugs are found and fixed, a note to the author explaining the problem and
fix would be nice.
-----------------------------------------------------------------------------

            Instructions on using the Image Viewer utility
            ==============================================

The Image Viewer utility is used to show the contents of memory device contexts
and in memory bitmaps while you are stepping through some drawing code.

To use the image viewer utility, make sure the ViewerDll.dll file is in your 
executable path, the ViewerApp.exe program is running, the ViewerDll.lib
file is in your library include path, and then simply include this file
in any file you want to use it in. This utility only works in debug builds
and you turn the tool on by #defining the 'ACTIVATE_VIEWER' macro.

  ie.
     #define ACTIVATE_VIEWER
     #include "ImageViewer.h"


This file defines the following macros

  ShowBitmap (HBITMAP bmp)

      bmp [in] - A HBITMAP or a CBitmap object

      Displays the contents of an in memory bitmap


  ShowDC (HDC dc)

      dc [in] - A HDC or a CDC object

      Displays the contents of a memory device context


  ShowGDIPlusBitmap (Gdiplus::Bitmap bmp)

      bmp [in] - A Gdiplus Bitmap

      Displays the contents of an in memory GDI+ Bitmap


  ShowIcon (HICON icon)

      icon [in] - A HICON object

      Displays the contents of a HICON handle


  ShowImageList (HIMAGELIST List, int Index, UINT Flags)

      List  [in] - A HIMAGELIST or a CImageList object
      Index [in] - Index of image in list to show, -1 for all
      Flags [in] - The ILD_* flag that specifies how to display the image

      Displays the contents of an in memory image list


If the ACTIVATE_VIEWER and _DEBUG macros are not defined, the Show* macros
are ignored, The ViewerDll.lib file is not linked, and the ViewerDll.dll
is not loaded.

If the Image Viewer tool is active, the VIEWER_ACTIVE macro will be defined,
so you can control extra code around the Show* macros by checking for the
VIEWER_ACTIVE macro.

  ie.
     #ifdef VIEWER_ACTIVE

     // Some code that requires the image viewer tool

     #endif // VIEWER_ACTIVE

****************************************************************************/

#ifndef PJA_IMAGE_VIEWER_UTILITY_HEADER_FILE_INCLUDED
#    define PJA_IMAGE_VIEWER_UTILITY_HEADER_FILE_INCLUDED

#    if _MSC_VER > 1000
#        pragma once
#    endif // _MSC_VER > 1000

#    undef VIEWER_ACTIVE

#    ifdef _DEBUG
#        ifdef ACTIVATE_VIEWER
#            define VIEWER_ACTIVE
#        endif // ACTIVATE_VIEWER
#    endif // _DEBUG

#    ifdef VIEWER_ACTIVE
#        pragma comment(lib, "viewerdll")

#        define ShowIcon(icon)  IconView((icon))
#        define ShowBitmap(bmp) ImageView((bmp))
#        define ShowDC(dc)      ImageView((HBITMAP)GetCurrentObject((dc),OBJ_BITMAP))

#        ifdef _INC_COMMCTRL   // defined in CommCtrl.h; header needed for HIMAGELIST
#            define ShowImageList(List,Index,Flags)  ImageListView((List),(Index),(Flags))
#        else
#            define ShowImageList(List,Index,Flags)
#        endif // _INC_COMMCTRL

#        ifdef __cplusplus
             extern "C" {
#        endif // __cplusplus

         // Do not call these functions directly in your code, doing so
         // will cause linker and/or run time errors if the Image Viewer
         // tool is turned off. Use the Show* macros instead.
         __declspec(dllimport) void ImageView(HBITMAP);
         __declspec(dllimport) void IconView(HICON);

#        ifdef _INC_COMMCTRL
             __declspec(dllimport) void ImageListView(HIMAGELIST,int,UINT);
#        endif // _INC_COMMCTRL

#        ifdef __cplusplus
             }
#        endif // __cplusplus

#        ifdef _GDIPLUS_H   // defined in GdiPlus.h
             // Use an inline static class member function to avoid LNK2005 errors.
             // This is placed here and not in the dll so users of the dll do not
             // have to have GDI+ installed on their machines.
             class DA9727EEC4E4438AACB39A9F5AACD96E
             {
             public:
                 static void GDIPlusBitmapView (Gdiplus::Bitmap &bmp)
                 {
                    HBITMAP hbmp;
                    if (Gdiplus::Ok == bmp.GetHBITMAP(Gdiplus::Color(192, 192, 192), &hbmp))
                        ImageView(hbmp);
                 }
             };
#            define ShowGDIPlusBitmap(bmp) DA9727EEC4E4438AACB39A9F5AACD96E::GDIPlusBitmapView((bmp))
#        else
#            define ShowGDIPlusBitmap(bmp)
#        endif // _GDIPLUS_H

#    else // VIEWER_ACTIVE
#        define ShowIcon(icon)
#        define ShowBitmap(bmp)
#        define ShowDC(dc)
#        define ShowImageList(List,Index,Flags)
#        define ShowGDIPlusBitmap(Bitmap)
#    endif // VIEWER_ACTIVE

#endif // PJA_IMAGE_VIEWER_UTILITY_HEADER_FILE_INCLUDED
